/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;

public interface StaticBuffer
extends Comparable<StaticBuffer> {
    public static final Factory<byte[]> ARRAY_FACTORY = (array, offset, limit) -> {
        if (offset == 0 && limit == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, offset, limit);
    };
    public static final Factory<ByteBuffer> BB_FACTORY = (array, offset, limit) -> ByteBuffer.wrap(array, offset, limit - offset);
    public static final Factory<StaticBuffer> STATIC_FACTORY = (array, offset, limit) -> new StaticArrayBuffer(array, offset, limit);

    public int length();

    public byte getByte(int var1);

    public boolean getBoolean(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public char getChar(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public byte[] getBytes(int var1, int var2);

    public short[] getShorts(int var1, int var2);

    public int[] getInts(int var1, int var2);

    public long[] getLongs(int var1, int var2);

    public char[] getChars(int var1, int var2);

    public float[] getFloats(int var1, int var2);

    public double[] getDoubles(int var1, int var2);

    public StaticBuffer subrange(int var1, int var2);

    public StaticBuffer subrange(int var1, int var2, boolean var3);

    public ReadBuffer asReadBuffer();

    public <T> T as(Factory<T> var1);

    public ByteBuffer asByteBuffer();

    public static interface Factory<T> {
        public T get(byte[] var1, int var2, int var3);
    }
}

