/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.idmanagement.ConflictAvoidanceMode;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.database.serialize.StandardSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOption<O>
extends ConfigElement {
    private static final Logger log = LoggerFactory.getLogger(ConfigOption.class);
    private static final EnumSet<Type> managedTypes = EnumSet.of(Type.FIXED, Type.GLOBAL_OFFLINE, Type.GLOBAL);
    private static final Set<Class<?>> ACCEPTED_DATATYPES = ImmutableSet.of(ConflictAvoidanceMode.class, Duration.class, TimestampProviders.class, Instant.class, Boolean.class, Short.class, (Object[])new Class[]{Integer.class, Byte.class, Long.class, Float.class, Double.class, String.class, String[].class});
    private static final String ACCEPTED_DATATYPES_STRING;
    private final Type type;
    private final Class<O> datatype;
    private final O defaultValue;
    private final Predicate<O> verificationFct;
    private boolean isHidden = false;
    private ConfigOption<?> supersededBy;

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, O defaultValue) {
        this(parent, name, description, type, defaultValue, ConfigOption.disallowEmpty(defaultValue.getClass()));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, O defaultValue, Predicate<O> verificationFct) {
        this(parent, name, description, type, defaultValue.getClass(), defaultValue, verificationFct);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> datatype) {
        this(parent, name, description, type, (Class<Predicate<O>>)datatype, ConfigOption.disallowEmpty(datatype));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> datatype, Predicate<O> verificationFct) {
        this(parent, name, description, type, datatype, null, verificationFct);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> datatype, O defaultValue) {
        this(parent, name, description, type, datatype, defaultValue, ConfigOption.disallowEmpty(datatype));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> datatype, O defaultValue, Predicate<O> verificationFct) {
        this(parent, name, description, type, datatype, defaultValue, verificationFct, null);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> datatype, O defaultValue, Predicate<O> verificationFct, ConfigOption<?> supersededBy) {
        super(parent, name, description);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull(verificationFct);
        this.type = type;
        this.datatype = datatype;
        this.defaultValue = defaultValue;
        this.verificationFct = verificationFct;
        this.supersededBy = supersededBy;
        if (!ACCEPTED_DATATYPES.contains(datatype)) {
            String msg = String.format("Datatype %s is not one of %s", datatype, ACCEPTED_DATATYPES_STRING);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public ConfigOption<O> hide() {
        this.isHidden = true;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public Type getType() {
        return this.type;
    }

    public Class<O> getDatatype() {
        return this.datatype;
    }

    public O getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isFixed() {
        return this.type == Type.FIXED;
    }

    public boolean isGlobal() {
        return this.type == Type.FIXED || this.type == Type.GLOBAL_OFFLINE || this.type == Type.GLOBAL || this.type == Type.MASKABLE;
    }

    public boolean isManaged() {
        return managedTypes.contains((Object)this.type);
    }

    public static EnumSet<Type> getManagedTypes() {
        return EnumSet.copyOf(managedTypes);
    }

    public boolean isLocal() {
        return this.type == Type.MASKABLE || this.type == Type.LOCAL;
    }

    public boolean isDeprecated() {
        return null != this.supersededBy;
    }

    public ConfigOption<?> getDeprecationReplacement() {
        return this.supersededBy;
    }

    @Override
    public boolean isOption() {
        return true;
    }

    public O get(Object input) {
        if (input == null) {
            input = this.defaultValue;
        }
        if (input == null) {
            Preconditions.checkState((boolean)this.verificationFct.apply(input), (String)"Need to set configuration value: %s", (Object[])new Object[]{this.toString()});
            return null;
        }
        return this.verify(input);
    }

    public O verify(Object input) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((boolean)this.datatype.isInstance(input), (String)"Invalid class for configuration value [%s]. Expected [%s] but given [%s]", (Object[])new Object[]{this.toString(), this.datatype, input.getClass()});
        Object result = input;
        Preconditions.checkArgument((boolean)this.verificationFct.apply(result), (String)"Invalid configuration value for [%s]: %s", (Object[])new Object[]{this.toString(), input});
        return (O)result;
    }

    public static final <E extends Enum> E getEnumValue(String str, Class<E> enumClass) {
        if (StringUtils.isBlank((CharSequence)(str = str.trim()))) {
            return null;
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            if (!e.toString().equalsIgnoreCase(str)) continue;
            return (E)e;
        }
        throw new IllegalArgumentException("Invalid enum string provided for [" + enumClass + "]: " + str);
    }

    public static final <O> Predicate<O> disallowEmpty(Class<O> clazz) {
        return new Predicate<O>(){

            public boolean apply(@Nullable O o) {
                if (o == null) {
                    return false;
                }
                if (o instanceof String) {
                    return StringUtils.isNotBlank((CharSequence)((String)o));
                }
                if (o.getClass().isArray() && (Array.getLength(o) == 0 || Array.get(o, 0) == null)) {
                    return false;
                }
                return !(o instanceof Collection) || !((Collection)o).isEmpty() && ((Collection)o).iterator().next() != null;
            }
        };
    }

    public static final Predicate<Integer> positiveInt() {
        return new Predicate<Integer>(){

            public boolean apply(@Nullable Integer num) {
                return num != null && num > 0;
            }
        };
    }

    public static final Predicate<Integer> nonnegativeInt() {
        return new Predicate<Integer>(){

            public boolean apply(@Nullable Integer num) {
                return num != null && num >= 0;
            }
        };
    }

    public static final Predicate<Long> positiveLong() {
        return new Predicate<Long>(){

            public boolean apply(@Nullable Long num) {
                return num != null && num > 0L;
            }
        };
    }

    static {
        StandardSerializer ss = new StandardSerializer();
        for (Class<?> c : ACCEPTED_DATATYPES) {
            if (ss.validDataType(c)) continue;
            String msg = String.format("%s datatype %s is not accepted by %s", ConfigOption.class.getSimpleName(), c, StandardSerializer.class.getSimpleName());
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        ACCEPTED_DATATYPES_STRING = Joiner.on((String)", ").join(ACCEPTED_DATATYPES);
    }

    public static enum Type {
        FIXED,
        GLOBAL_OFFLINE,
        GLOBAL,
        MASKABLE,
        LOCAL;

    }
}

