/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;

public class ModifiableConfiguration
extends BasicConfiguration {
    private final WriteConfiguration config;

    public ModifiableConfiguration(ConfigNamespace root, WriteConfiguration config, BasicConfiguration.Restriction restriction) {
        super(root, config, restriction);
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public <O> ModifiableConfiguration set(ConfigOption<O> option, O value, String ... umbrellaElements) {
        this.verifyOption(option);
        Preconditions.checkArgument((!option.isFixed() || !this.isFrozen() ? 1 : 0) != 0, (String)"Cannot change configuration option: %s", (Object[])new Object[]{option});
        String key = super.getPath(option, umbrellaElements);
        value = option.verify(value);
        this.config.set(key, value);
        return this;
    }

    public void setAll(Map<ConfigElement.PathIdentifier, Object> options) {
        for (Map.Entry<ConfigElement.PathIdentifier, Object> entry : options.entrySet()) {
            Preconditions.checkArgument((boolean)entry.getKey().element.isOption());
            this.set((ConfigOption)entry.getKey().element, entry.getValue(), entry.getKey().umbrellaElements);
        }
    }

    public <O> void remove(ConfigOption<O> option, String ... umbrellaElements) {
        this.verifyOption(option);
        Preconditions.checkArgument((!option.isFixed() || !this.isFrozen() ? 1 : 0) != 0, (String)"Cannot change configuration option: %s", (Object[])new Object[]{option});
        String key = super.getPath(option, umbrellaElements);
        this.config.remove(key);
    }

    public void freezeConfiguration() {
        this.config.set("hidden.frozen", Boolean.TRUE);
        if (!this.isFrozen()) {
            this.setFrozen();
        }
    }

    @Override
    public WriteConfiguration getConfiguration() {
        return this.config;
    }
}

