/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.MetaAnnotatable;
import org.janusgraph.diskstorage.MetaAnnotated;

public class IndexEntry
implements MetaAnnotated,
MetaAnnotatable {
    public final String field;
    public final Object value;
    private Map<EntryMetaData, Object> metadata = EntryMetaData.EMPTY_METADATA;

    public IndexEntry(String field, Object value) {
        this(field, value, null);
    }

    public IndexEntry(String field, Object value, Map<EntryMetaData, Object> metadata) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)field));
        this.field = field;
        this.value = value;
        if (metadata == null || metadata == EntryMetaData.EMPTY_METADATA) {
            return;
        }
        for (Map.Entry<EntryMetaData, Object> e : metadata.entrySet()) {
            this.setMetaData(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized Object setMetaData(EntryMetaData key, Object value) {
        if (this.metadata == EntryMetaData.EMPTY_METADATA) {
            this.metadata = new EntryMetaData.Map();
        }
        return this.metadata.put(key, value);
    }

    @Override
    public boolean hasMetaData() {
        return !this.metadata.isEmpty();
    }

    @Override
    public Map<EntryMetaData, Object> getMetaData() {
        return this.metadata;
    }
}

