/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.LocalLockMediator;
import org.janusgraph.diskstorage.locking.LocalLockMediators;
import org.janusgraph.diskstorage.locking.LockStatus;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.LockerState;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.TemporaryLockingException;
import org.janusgraph.diskstorage.locking.consistentkey.ConsistentKeyLockerSerializer;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.stats.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocker<S extends LockStatus>
implements Locker {
    protected final StaticBuffer rid;
    protected final TimestampProvider times;
    protected final ConsistentKeyLockerSerializer serializer;
    protected final LocalLockMediator<StoreTransaction> llm;
    protected final LockerState<S> lockState;
    protected final Duration lockExpire;
    protected final Logger log;
    private static final String M_LOCKS = "locks";
    private static final String M_WRITE = "write";
    private static final String M_CHECK = "check";
    private static final String M_DELETE = "delete";
    private static final String M_CALLS = "calls";
    private static final String M_EXCEPTIONS = "exceptions";

    public AbstractLocker(StaticBuffer rid, TimestampProvider times, ConsistentKeyLockerSerializer serializer, LocalLockMediator<StoreTransaction> llm, LockerState<S> lockState, Duration lockExpire, Logger log) {
        this.rid = rid;
        this.times = times;
        this.serializer = serializer;
        this.llm = llm;
        this.lockState = lockState;
        this.lockExpire = lockExpire;
        this.log = log;
    }

    protected abstract S writeSingleLock(KeyColumn var1, StoreTransaction var2) throws Throwable;

    protected abstract void checkSingleLock(KeyColumn var1, S var2, StoreTransaction var3) throws Throwable;

    protected abstract void deleteSingleLock(KeyColumn var1, S var2, StoreTransaction var3) throws Throwable;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeLock(KeyColumn lockID, StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        if (null != tx.getConfiguration().getGroupName()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_WRITE, M_CALLS).inc();
        }
        if (this.lockState.has(tx, lockID)) {
            this.log.debug("Transaction {} already wrote lock on {}", (Object)tx, (Object)lockID);
            return;
        }
        if (!this.lockLocally(lockID, tx)) {
            throw new PermanentLockingException("Local lock contention");
        }
        boolean ok = false;
        try {
            S stat = this.writeSingleLock(lockID, tx);
            this.lockLocally(lockID, stat.getExpirationTimestamp(), tx);
            this.lockState.take(tx, lockID, stat);
            return;
        }
        catch (TemporaryBackendException tse) {
            try {
                throw new TemporaryLockingException(tse);
                catch (AssertionError ae) {
                    ok = true;
                    throw ae;
                }
                catch (Throwable t) {
                    throw new PermanentLockingException(t);
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.unlockLocally(lockID, tx);
                    if (null != tx.getConfiguration().getGroupName()) {
                        MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_WRITE, M_EXCEPTIONS).inc();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkLocks(StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        Map<KeyColumn, S> m;
        if (null != tx.getConfiguration().getGroupName()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_CHECK, M_CALLS).inc();
        }
        if ((m = this.lockState.getLocksForTx(tx)).isEmpty()) {
            return;
        }
        boolean ok = false;
        try {
            for (Map.Entry<KeyColumn, S> entry : m.entrySet()) {
                this.checkSingleLock(entry.getKey(), (LockStatus)entry.getValue(), tx);
            }
            ok = true;
            if (ok) return;
            if (null == tx.getConfiguration().getGroupName()) return;
        }
        catch (TemporaryLockingException tle) {
            try {
                throw tle;
                catch (PermanentLockingException ple) {
                    throw ple;
                }
                catch (AssertionError ae) {
                    throw ae;
                }
                catch (InterruptedException e) {
                    throw new TemporaryLockingException(e);
                }
                catch (TemporaryBackendException tse) {
                    throw new TemporaryLockingException(tse);
                }
                catch (Throwable t) {
                    throw new PermanentLockingException(t);
                }
            }
            catch (Throwable throwable) {
                if (ok) throw throwable;
                if (null == tx.getConfiguration().getGroupName()) throw throwable;
                MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_CHECK, M_CALLS).inc();
                throw throwable;
            }
        }
        MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_CHECK, M_CALLS).inc();
    }

    @Override
    public void deleteLocks(StoreTransaction tx) throws TemporaryLockingException, PermanentLockingException {
        if (null != tx.getConfiguration().getGroupName()) {
            MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_DELETE, M_CALLS).inc();
        }
        Map<KeyColumn, S> m = this.lockState.getLocksForTx(tx);
        Iterator<Map.Entry<KeyColumn, S>> iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            KeyColumn kc;
            block5: {
                Map.Entry<KeyColumn, S> entry = iter.next();
                kc = entry.getKey();
                LockStatus ls = (LockStatus)entry.getValue();
                try {
                    this.deleteSingleLock(kc, ls, tx);
                }
                catch (AssertionError ae) {
                    throw ae;
                }
                catch (Throwable t) {
                    this.log.error("Exception while deleting lock on " + kc, t);
                    if (null == tx.getConfiguration().getGroupName()) break block5;
                    MetricManager.INSTANCE.getCounter(tx.getConfiguration().getGroupName(), M_LOCKS, M_DELETE, M_CALLS).inc();
                }
            }
            this.llm.unlock(kc, tx);
            iter.remove();
        }
    }

    private boolean lockLocally(KeyColumn lockID, StoreTransaction tx) {
        return this.lockLocally(lockID, this.times.getTime().plus(this.lockExpire), tx);
    }

    private boolean lockLocally(KeyColumn lockID, Instant expire, StoreTransaction tx) {
        return this.llm.lock(lockID, tx, expire);
    }

    private void unlockLocally(KeyColumn lockID, StoreTransaction txh) {
        this.llm.unlock(lockID, txh);
    }

    public static abstract class Builder<S, B extends Builder<S, B>> {
        protected StaticBuffer rid = null;
        protected TimestampProvider times = TimestampProviders.NANO;
        protected ConsistentKeyLockerSerializer serializer = new ConsistentKeyLockerSerializer();
        protected LocalLockMediator<StoreTransaction> llm = null;
        protected LockerState<S> lockState = new LockerState();
        protected Duration lockExpire = GraphDatabaseConfiguration.LOCK_EXPIRE.getDefaultValue();
        protected Logger log = LoggerFactory.getLogger(AbstractLocker.class);

        protected abstract B self();

        public B rid(StaticBuffer rid) {
            this.rid = rid;
            return this.self();
        }

        public B times(TimestampProvider times) {
            this.times = times;
            return this.self();
        }

        public B serializer(ConsistentKeyLockerSerializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        public B mediator(LocalLockMediator<StoreTransaction> mediator) {
            this.llm = mediator;
            return this.self();
        }

        public B mediatorName(String name) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)this.times, (Object)"Timestamp provider must be set before initializing local lock mediator");
            this.mediator(LocalLockMediators.INSTANCE.get(name, this.times));
            return this.self();
        }

        public B logger(Logger log) {
            this.log = log;
            return this.self();
        }

        public B lockExpire(Duration d) {
            this.lockExpire = d;
            return this.self();
        }

        public B internalState(LockerState<S> state) {
            this.lockState = state;
            return this.self();
        }

        protected void preBuild() {
            if (null == this.llm) {
                this.llm = this.getDefaultMediator();
            }
        }

        protected abstract LocalLockMediator<StoreTransaction> getDefaultMediator();
    }
}

