/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import java.nio.ByteBuffer;
import org.janusgraph.diskstorage.util.Hex;

public class ByteBufferUtil {
    public static final ByteBuffer zeroByteBuffer(int len) {
        ByteBuffer res = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            res.put((byte)0);
        }
        res.flip();
        return res;
    }

    public static final ByteBuffer oneByteBuffer(int len) {
        ByteBuffer res = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            res.put((byte)-1);
        }
        res.flip();
        return res;
    }

    public static final boolean isSmallerThan(ByteBuffer a, ByteBuffer b) {
        return ByteBufferUtil.compare(a, b) < 0;
    }

    public static boolean isSmallerOrEqualThan(ByteBuffer a, ByteBuffer b) {
        return ByteBufferUtil.compare(a, b) <= 0;
    }

    public static final int compare(ByteBuffer b1, ByteBuffer b2) {
        if (b1 == b2) {
            return 0;
        }
        int p1 = b1.position();
        for (int p2 = b2.position(); p1 < b1.limit() || p2 < b2.limit(); ++p1, ++p2) {
            if (p1 >= b1.limit()) {
                return -1;
            }
            if (p2 >= b2.limit()) {
                return 1;
            }
            int cmp = ByteBufferUtil.compare(b1.get(p1), b2.get(p2));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static int compare(byte c1, byte c2) {
        int a = c1 & 0xFF;
        int b = c2 & 0xFF;
        return a - b;
    }

    public static String bytesToHex(ByteBuffer bytes) {
        int offset = bytes.position();
        int size = bytes.remaining();
        char[] c = new char[size * 2];
        for (int i = 0; i < size; ++i) {
            byte bint = bytes.get(i + offset);
            c[i * 2] = Hex.byteToChar[(bint & 0xF0) >> 4];
            c[1 + i * 2] = Hex.byteToChar[bint & 0xF];
        }
        return Hex.wrapCharArray(c);
    }

    public static final String toString(ByteBuffer b, String separator) {
        StringBuilder s = new StringBuilder();
        for (int i = b.position(); i < b.limit(); ++i) {
            byte c;
            if (i > b.position()) {
                s.append(separator);
            }
            if ((c = b.get(i)) >= 0) {
                s.append(c);
                continue;
            }
            s.append(256 + c);
        }
        return s.toString();
    }
}

