/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.IOCallable;
import org.janusgraph.diskstorage.util.MetricInstrumentedIterator;
import org.janusgraph.diskstorage.util.StorageCallable;
import org.janusgraph.diskstorage.util.UncheckedCallable;
import org.janusgraph.util.stats.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricInstrumentedStore
implements KeyColumnValueStore {
    private final KeyColumnValueStore backend;
    private static final Logger log = LoggerFactory.getLogger(MetricInstrumentedStore.class);
    public static final String M_CONTAINS_KEY = "containsKey";
    public static final String M_GET_SLICE = "getSlice";
    public static final String M_MUTATE = "mutate";
    public static final String M_ACQUIRE_LOCK = "acquireLock";
    public static final String M_GET_KEYS = "getKeys";
    public static final String M_GET_PART = "getLocalKeyPartition";
    public static final String M_CLOSE = "close";
    public static final List<String> OPERATION_NAMES = ImmutableList.of((Object)"containsKey", (Object)"getSlice", (Object)"mutate", (Object)"acquireLock", (Object)"getKeys");
    public static final String M_CALLS = "calls";
    public static final String M_TIME = "time";
    public static final String M_EXCEPTIONS = "exceptions";
    public static final String M_ENTRIES_COUNT = "entries-returned";
    public static final String M_ENTRIES_HISTO = "entries-histogram";
    public static final List<String> EVENT_NAMES = ImmutableList.of((Object)"calls", (Object)"time", (Object)"exceptions", (Object)"entries-returned", (Object)"entries-histogram");
    public static final String M_ITERATOR = "iterator";
    private final String metricsStoreName;

    public MetricInstrumentedStore(KeyColumnValueStore backend, String metricsStoreName) {
        this.backend = backend;
        this.metricsStoreName = metricsStoreName;
        log.debug("Wrapped Metrics named \"{}\" around store {}", (Object)metricsStoreName, (Object)backend);
    }

    @Override
    public EntryList getSlice(final KeySliceQuery query, final StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_SLICE, new StorageCallable<EntryList>(){

            @Override
            public EntryList call() throws BackendException {
                EntryList result = MetricInstrumentedStore.this.backend.getSlice(query, txh);
                MetricInstrumentedStore.this.recordSliceMetrics(txh, result);
                return result;
            }
        });
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(final List<StaticBuffer> keys, final SliceQuery query, final StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_SLICE, new StorageCallable<Map<StaticBuffer, EntryList>>(){

            @Override
            public Map<StaticBuffer, EntryList> call() throws BackendException {
                Map<StaticBuffer, EntryList> results = MetricInstrumentedStore.this.backend.getSlice(keys, query, txh);
                for (EntryList result : results.values()) {
                    MetricInstrumentedStore.this.recordSliceMetrics(txh, result);
                }
                return results;
            }
        });
    }

    @Override
    public void mutate(final StaticBuffer key, final List<Entry> additions, final List<StaticBuffer> deletions, final StoreTransaction txh) throws BackendException {
        MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_MUTATE, new StorageCallable<Void>(){

            @Override
            public Void call() throws BackendException {
                MetricInstrumentedStore.this.backend.mutate(key, additions, deletions, txh);
                return null;
            }
        });
    }

    @Override
    public void acquireLock(final StaticBuffer key, final StaticBuffer column, final StaticBuffer expectedValue, final StoreTransaction txh) throws BackendException {
        MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_ACQUIRE_LOCK, new StorageCallable<Void>(){

            @Override
            public Void call() throws BackendException {
                MetricInstrumentedStore.this.backend.acquireLock(key, column, expectedValue, txh);
                return null;
            }
        });
    }

    @Override
    public KeyIterator getKeys(final KeyRangeQuery query, final StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_KEYS, new StorageCallable<KeyIterator>(){

            @Override
            public KeyIterator call() throws BackendException {
                KeyIterator ki = MetricInstrumentedStore.this.backend.getKeys(query, txh);
                if (txh.getConfiguration().hasGroupName()) {
                    return MetricInstrumentedIterator.of(ki, txh.getConfiguration().getGroupName(), MetricInstrumentedStore.this.metricsStoreName, MetricInstrumentedStore.M_GET_KEYS, MetricInstrumentedStore.M_ITERATOR);
                }
                return ki;
            }
        });
    }

    @Override
    public KeyIterator getKeys(final SliceQuery query, final StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_KEYS, new StorageCallable<KeyIterator>(){

            @Override
            public KeyIterator call() throws BackendException {
                KeyIterator ki = MetricInstrumentedStore.this.backend.getKeys(query, txh);
                if (txh.getConfiguration().hasGroupName()) {
                    return MetricInstrumentedIterator.of(ki, txh.getConfiguration().getGroupName(), MetricInstrumentedStore.this.metricsStoreName, MetricInstrumentedStore.M_GET_KEYS, MetricInstrumentedStore.M_ITERATOR);
                }
                return ki;
            }
        });
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    @Override
    public void close() throws BackendException {
        this.backend.close();
    }

    private void recordSliceMetrics(StoreTransaction txh, List<Entry> row) {
        if (!txh.getConfiguration().hasGroupName()) {
            return;
        }
        String p = txh.getConfiguration().getGroupName();
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(p, this.metricsStoreName, M_GET_SLICE, M_ENTRIES_COUNT).inc((long)row.size());
        mgr.getHistogram(p, this.metricsStoreName, M_GET_SLICE, M_ENTRIES_HISTO).update(row.size());
    }

    static <T> T runWithMetrics(StoreTransaction txh, String storeName, String name, StorageCallable<T> impl) throws BackendException {
        if (!txh.getConfiguration().hasGroupName()) {
            return impl.call();
        }
        String prefix = txh.getConfiguration().getGroupName();
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, storeName, name, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, storeName, name, M_TIME).time();
        try {
            T t = impl.call();
            return t;
        }
        catch (BackendException e) {
            mgr.getCounter(prefix, storeName, name, M_EXCEPTIONS).inc();
            throw e;
        }
        catch (RuntimeException e) {
            mgr.getCounter(prefix, storeName, name, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    static <T> T runWithMetrics(String prefix, String storeName, String name, IOCallable<T> impl) throws IOException {
        if (null == prefix) {
            return impl.call();
        }
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, storeName, name, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, storeName, name, M_TIME).time();
        try {
            T t = impl.call();
            return t;
        }
        catch (IOException e) {
            mgr.getCounter(prefix, storeName, name, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    static <T> T runWithMetrics(String prefix, String storeName, String name, UncheckedCallable<T> impl) {
        if (null == prefix) {
            return impl.call();
        }
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, storeName, name, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, storeName, name, M_TIME).time();
        try {
            T t = impl.call();
            return t;
        }
        catch (RuntimeException e) {
            mgr.getCounter(prefix, storeName, name, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }
}

