/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.ReadArrayBuffer;

public class StaticArrayBuffer
implements StaticBuffer {
    private final byte[] array;
    private int offset;
    private int limit;
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int CHAR_LEN = 2;
    public static final int FLOAT_LEN = 4;
    public static final int DOUBLE_LEN = 8;

    public StaticArrayBuffer(byte[] array, int offset, int limit) {
        assert (array != null);
        assert (offset >= 0 && offset <= limit);
        assert (limit <= array.length);
        this.array = array;
        this.offset = offset;
        this.limit = limit;
    }

    public StaticArrayBuffer(byte[] array) {
        this(array, 0, array.length);
    }

    public StaticArrayBuffer(byte[] array, int limit) {
        this(array, 0, limit);
    }

    public StaticArrayBuffer(StaticBuffer buffer) {
        this((StaticArrayBuffer)buffer);
    }

    public StaticArrayBuffer(StaticArrayBuffer buffer) {
        this(buffer.array, buffer.offset, buffer.limit);
    }

    public static StaticArrayBuffer of(byte[] array) {
        return new StaticArrayBuffer(array);
    }

    public static StaticArrayBuffer of(ByteBuffer b) {
        if (b.hasArray()) {
            return new StaticArrayBuffer(b.array(), b.arrayOffset() + b.position(), b.arrayOffset() + b.limit());
        }
        byte[] array = new byte[b.remaining()];
        b.mark();
        b.get(array);
        b.reset();
        return StaticArrayBuffer.of(array);
    }

    void reset(int newOffset, int newLimit) {
        assert (newOffset >= 0 && newOffset <= newLimit);
        assert (newLimit <= this.array.length);
        this.offset = newOffset;
        this.limit = newLimit;
    }

    private int require(int position, int size) {
        int base = position + this.offset;
        if (position < 0) {
            throw new ArrayIndexOutOfBoundsException("Position [" + position + "] must be nonnegative");
        }
        if (base + size > this.limit) {
            throw new ArrayIndexOutOfBoundsException("Required size [" + size + "] exceeds actual remaining size [" + (this.limit - base) + "]");
        }
        assert (base + size <= this.limit);
        return base;
    }

    @Override
    public int length() {
        return this.limit - this.offset;
    }

    void copyTo(byte[] dest, int destOffset) {
        System.arraycopy(this.array, this.offset, dest, destOffset, this.length());
    }

    @Override
    public StaticBuffer subrange(int position, int length) {
        return this.subrange(position, length, false);
    }

    @Override
    public StaticBuffer subrange(int position, int length, boolean invert) {
        if (position < 0 || length < 0 || this.offset + position + length > this.limit) {
            throw new ArrayIndexOutOfBoundsException("Position [" + position + "] and or length [" + length + "] out of bounds");
        }
        if (!invert) {
            return new StaticArrayBuffer(this.array, this.offset + position, this.offset + position + length);
        }
        byte[] inverted = new byte[length];
        System.arraycopy(this.array, this.offset + position, inverted, 0, length);
        for (int i = 0; i < inverted.length; ++i) {
            inverted[i] = ~inverted[i];
        }
        return new StaticArrayBuffer(inverted);
    }

    @Override
    public ReadBuffer asReadBuffer() {
        return new ReadArrayBuffer(this);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.as(StaticBuffer.BB_FACTORY);
    }

    @Override
    public <T> T as(StaticBuffer.Factory<T> factory) {
        return factory.get(this.array, this.offset, this.limit);
    }

    protected <T> T as(StaticBuffer.Factory<T> factory, int position, int length) {
        if (position < 0 || length < 0 || this.offset + position + length > this.limit) {
            throw new ArrayIndexOutOfBoundsException("Position [" + position + "] and or length [" + length + "] out of bounds");
        }
        return factory.get(this.array, this.offset + position, this.offset + position + length);
    }

    @Override
    public byte getByte(int position) {
        return this.array[this.require(position, 1)];
    }

    @Override
    public boolean getBoolean(int position) {
        return this.getByte(position) > 0;
    }

    @Override
    public short getShort(int position) {
        int base = this.require(position, 2);
        return (short)((this.array[base++] & 0xFF) << 8 | this.array[base++] & 0xFF);
    }

    @Override
    public int getInt(int position) {
        int base = this.require(position, 4);
        return StaticArrayBuffer.getInt(this.array, base);
    }

    public static int getInt(byte[] array, int offset) {
        return (array[offset++] & 0xFF) << 24 | (array[offset++] & 0xFF) << 16 | (array[offset++] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    public static void putInt(byte[] array, int offset, int value) {
        array[offset++] = (byte)(value >> 24 & 0xFF);
        array[offset++] = (byte)(value >> 16 & 0xFF);
        array[offset++] = (byte)(value >> 8 & 0xFF);
        array[offset] = (byte)(value & 0xFF);
    }

    @Override
    public long getLong(int position) {
        int offset = this.require(position, 8);
        return StaticArrayBuffer.getLong(this.array, offset);
    }

    public static long getLong(byte[] array, int offset) {
        return (long)array[offset++] << 56 | (long)(array[offset++] & 0xFF) << 48 | (long)(array[offset++] & 0xFF) << 40 | (long)(array[offset++] & 0xFF) << 32 | (long)(array[offset++] & 0xFF) << 24 | (long)((array[offset++] & 0xFF) << 16) | (long)((array[offset++] & 0xFF) << 8) | (long)(array[offset++] & 0xFF);
    }

    public static void putLong(byte[] array, int offset, long value) {
        array[offset++] = (byte)(value >> 56);
        array[offset++] = (byte)(value >> 48 & 0xFFL);
        array[offset++] = (byte)(value >> 40 & 0xFFL);
        array[offset++] = (byte)(value >> 32 & 0xFFL);
        array[offset++] = (byte)(value >> 24 & 0xFFL);
        array[offset++] = (byte)(value >> 16 & 0xFFL);
        array[offset++] = (byte)(value >> 8 & 0xFFL);
        array[offset++] = (byte)(value & 0xFFL);
    }

    @Override
    public char getChar(int position) {
        return (char)this.getShort(position);
    }

    @Override
    public float getFloat(int position) {
        return Float.intBitsToFloat(this.getInt(position));
    }

    @Override
    public double getDouble(int position) {
        return Double.longBitsToDouble(this.getLong(position));
    }

    @Override
    public byte[] getBytes(int position, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getByte(position);
            ++position;
        }
        return result;
    }

    @Override
    public short[] getShorts(int position, int length) {
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getShort(position);
            position += 2;
        }
        return result;
    }

    @Override
    public int[] getInts(int position, int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getInt(position);
            position += 4;
        }
        return result;
    }

    @Override
    public long[] getLongs(int position, int length) {
        long[] result = new long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getLong(position);
            position += 8;
        }
        return result;
    }

    @Override
    public char[] getChars(int position, int length) {
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getChar(position);
            position += 2;
        }
        return result;
    }

    @Override
    public float[] getFloats(int position, int length) {
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getFloat(position);
            position += 4;
        }
        return result;
    }

    @Override
    public double[] getDoubles(int position, int length) {
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getDouble(position);
            position += 8;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof StaticBuffer)) {
            return false;
        }
        StaticBuffer b = (StaticBuffer)o;
        if (this.length() != b.length()) {
            return false;
        }
        return this.compareTo(b) == 0;
    }

    public int hashCode() {
        return this.hashCode(this.length());
    }

    protected int hashCode(int length) {
        Preconditions.checkArgument((length <= this.length() ? 1 : 0) != 0);
        int result = 17;
        for (int i = this.offset; i < this.offset + length; ++i) {
            result = 31 * result + this.array[i];
        }
        return result;
    }

    public String toString() {
        return this.toString("-");
    }

    public final String toString(String separator) {
        StringBuilder s = new StringBuilder();
        for (int i = this.offset; i < this.limit; ++i) {
            if (i > this.offset) {
                s.append(separator);
            }
            s.append(StaticArrayBuffer.toFixedWidthString(this.array[i]));
        }
        return s.toString();
    }

    private static String toString(byte b) {
        return String.valueOf(b >= 0 ? b : 256 + b);
    }

    private static String toFixedWidthString(byte b) {
        String s = StaticArrayBuffer.toString(b);
        assert (s.length() <= 3 && s.length() > 0);
        if (s.length() == 1) {
            s = "  " + s;
        } else if (s.length() == 2) {
            s = " " + s;
        }
        return s;
    }

    @Override
    public int compareTo(StaticBuffer other) {
        assert (other instanceof StaticArrayBuffer);
        return this.compareTo((StaticArrayBuffer)other);
    }

    @Override
    public int compareTo(StaticArrayBuffer other) {
        return StaticArrayBuffer.compareTo(this.array, this.offset, this.limit, other.array, other.offset, other.limit);
    }

    protected int compareTo(int length, StaticBuffer buffer, int bufferLen) {
        assert (buffer instanceof StaticArrayBuffer);
        return this.compareTo(length, (StaticArrayBuffer)buffer, bufferLen);
    }

    protected int compareTo(int length, StaticArrayBuffer buffer, int bufferLen) {
        assert (buffer != null);
        Preconditions.checkArgument((length <= this.length() && bufferLen <= buffer.length() ? 1 : 0) != 0);
        return StaticArrayBuffer.compareTo(this.array, this.offset, this.offset + length, buffer.array, buffer.offset, buffer.offset + bufferLen);
    }

    private static int compareTo(byte[] buffer1, int offset1, int end1, byte[] buffer2, int offset2, int end2) {
        int length1 = end1 - offset1;
        int length2 = end2 - offset2;
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }
}

