/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.IntegerSerializer;
import org.janusgraph.util.encoding.NumericUtils;

public class FloatSerializer
implements OrderPreservingSerializer<Float> {
    private final IntegerSerializer ints = new IntegerSerializer();

    @Override
    public Float convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value too large for float: " + value);
            }
            return Float.valueOf((float)d);
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    @Override
    public Float read(ScanBuffer buffer) {
        return Float.valueOf(buffer.getFloat());
    }

    @Override
    public void write(WriteBuffer buffer, Float attribute) {
        buffer.putFloat(attribute.floatValue());
    }

    @Override
    public Float readByteOrder(ScanBuffer buffer) {
        return Float.valueOf(NumericUtils.sortableIntToFloat(this.ints.readByteOrder(buffer)));
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Float attribute) {
        this.ints.writeByteOrder(buffer, NumericUtils.floatToSortableInt(attribute.floatValue()));
    }
}

