/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class IntArraySerializer
extends ArraySerializer
implements AttributeSerializer<int[]> {
    @Override
    public int[] convert(Object value) {
        return (int[])this.convertInternal(value, Integer.TYPE, Integer.class);
    }

    @Override
    protected Object getArray(int length) {
        return new int[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setInt(array, pos, (Integer)value);
    }

    @Override
    public int[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getInts(length);
    }

    @Override
    public void write(WriteBuffer buffer, int[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (int i = 0; i < attribute.length; ++i) {
                buffer.putInt(attribute[i]);
            }
        }
    }
}

