/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class LongArraySerializer
extends ArraySerializer
implements AttributeSerializer<long[]> {
    @Override
    public long[] convert(Object value) {
        return (long[])this.convertInternal(value, Long.TYPE, Long.class);
    }

    @Override
    protected Object getArray(int length) {
        return new long[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setLong(array, pos, (Long)value);
    }

    @Override
    public long[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getLongs(length);
    }

    @Override
    public void write(WriteBuffer buffer, long[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (int i = 0; i < attribute.length; ++i) {
                buffer.putLong(attribute[i]);
            }
        }
    }
}

