/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.janusgraph.core.Namifiable;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.SupportsNullSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.CharacterSerializer;
import org.janusgraph.util.encoding.StringEncoding;

public class StringSerializer
implements OrderPreservingSerializer<String>,
SupportsNullSerializer {
    public static final int MAX_LENGTH = 0x8000000;
    public static final int LONG_COMPRESSION_THRESHOLD = 16000;
    public static final int TEXT_COMRPESSION_THRESHOLD = 48;
    private static final long COMPRESSOR_BIT_LEN = 3L;
    private static final int MAX_NUM_COMPRESSORS = 8;
    private static final long COMPRESSOR_BIT_MASK = 7L;
    private static final long NO_COMPRESSION_OFFSET = 4L;
    private final CharacterSerializer cs = new CharacterSerializer();

    @Override
    public String readByteOrder(ScanBuffer buffer) {
        char c;
        byte prefix = buffer.getByte();
        if (prefix == -1) {
            return null;
        }
        assert (prefix == 0);
        StringBuilder s = new StringBuilder();
        while ((c = this.cs.readByteOrder(buffer).charValue()) > '\u0000') {
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, String attribute) {
        if (attribute == null) {
            buffer.putByte((byte)-1);
            return;
        }
        buffer.putByte((byte)0);
        for (int i = 0; i < attribute.length(); ++i) {
            char c = attribute.charAt(i);
            Preconditions.checkArgument((c > '\u0000' ? 1 : 0) != 0, (String)"No null characters allowed in string @ position %s: %s", (Object[])new Object[]{i, attribute});
            this.cs.writeByteOrder(buffer, Character.valueOf(c));
        }
        this.cs.writeByteOrder(buffer, Character.valueOf('\u0000'));
    }

    @Override
    public void verifyAttribute(String value) {
        Preconditions.checkArgument((value.length() <= 0x8000000 ? 1 : 0) != 0, (String)"String is too long: %s", (Object[])new Object[]{value.length()});
    }

    @Override
    public String convert(Object value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Namifiable) {
            return ((Namifiable)value).name();
        }
        return value.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String read(ScanBuffer buffer) {
        long length = VariableLong.readPositive(buffer);
        if (length == 0L) {
            return null;
        }
        long compressionId = length & 7L;
        assert (compressionId < 8L);
        CompressionType compression = CompressionType.getFromId((int)compressionId);
        length >>>= 3;
        if (compression == CompressionType.NO_COMPRESSION) {
            if ((length & 1L) == 0L) {
                int c;
                if ((length >>>= 1) == 1L) {
                    return "";
                }
                if (length != 2L) throw new IllegalArgumentException("Invalid ASCII encoding offset: " + length);
                StringBuilder sb = new StringBuilder();
                do {
                    c = 0xFF & buffer.getByte();
                    sb.append((char)(c & 0x7F));
                } while ((c & 0x80) <= 0);
                return sb.toString();
            }
            length >>>= 1;
            if (!$assertionsDisabled) {
                if (length <= 0L) throw new AssertionError();
                if (length > Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
            }
            StringBuilder sb = new StringBuilder((int)length);
            int i = 0;
            while ((long)i < length) {
                int b = buffer.getByte() & 0xFF;
                switch (b >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        sb.append((char)b);
                        break;
                    }
                    case 12: 
                    case 13: {
                        sb.append((char)((b & 0x1F) << 6 | buffer.getByte() & 0x3F));
                        break;
                    }
                    case 14: {
                        sb.append((char)((b & 0xF) << 12 | (buffer.getByte() & 0x3F) << 6 | buffer.getByte() & 0x3F));
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        if ($assertionsDisabled) return compression.decompress(buffer, (int)length);
        if (length <= Integer.MAX_VALUE) return compression.decompress(buffer, (int)length);
        throw new AssertionError();
    }

    @Override
    public void write(WriteBuffer buffer, String attribute) {
        if (attribute == null) {
            VariableLong.writePositive(buffer, 0L);
            return;
        }
        CompressionType compression = attribute.length() > 16000 ? CompressionType.GZIP : CompressionType.NO_COMPRESSION;
        assert (compression != null);
        assert (compression.getId() < 8);
        if (compression == CompressionType.NO_COMPRESSION) {
            assert (compression.getId() == 0);
            if (StringEncoding.isAsciiString(attribute)) {
                if (attribute.length() == 0) {
                    VariableLong.writePositive(buffer, 16L);
                } else {
                    VariableLong.writePositive(buffer, 32L);
                }
                for (int i = 0; i < attribute.length(); ++i) {
                    char c = attribute.charAt(i);
                    assert (c <= '\u007f');
                    byte b = (byte)c;
                    if (i + 1 == attribute.length()) {
                        b = (byte)(b | 0x80);
                    }
                    buffer.putByte(b);
                }
            } else {
                assert (attribute.length() > 0);
                VariableLong.writePositive(buffer, ((long)attribute.length() << 4) + 8L);
                for (int i = 0; i < attribute.length(); ++i) {
                    char c = attribute.charAt(i);
                    if (c <= '\u007f') {
                        buffer.putByte((byte)c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        buffer.putByte((byte)(0xE0 | c >> 12 & 0xF));
                        buffer.putByte((byte)(0x80 | c >> 6 & 0x3F));
                        buffer.putByte((byte)(0x80 | c & 0x3F));
                        continue;
                    }
                    buffer.putByte((byte)(0xC0 | c >> 6 & 0x1F));
                    buffer.putByte((byte)(0x80 | c & 0x3F));
                }
            }
        } else {
            byte[] compressed = compression.compress(attribute);
            int length = compressed.length;
            assert (length > 0);
            VariableLong.writePositive(buffer, ((long)length << 3) + (long)compression.getId());
            buffer.putBytes(compressed);
        }
    }

    private static enum CompressionType {
        NO_COMPRESSION{

            @Override
            public byte[] compress(String text) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String decompress(ScanBuffer buffer, int numBytes) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        GZIP{

            @Override
            public byte[] compress(String text) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    GZIPOutputStream out = new GZIPOutputStream(baos);
                    ((OutputStream)out).write(text.getBytes("UTF-8"));
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return baos.toByteArray();
            }

            @Override
            public String decompress(final ScanBuffer buffer, final int numBytes) {
                try {
                    int len;
                    GZIPInputStream in = new GZIPInputStream(new InputStream(){
                        int bytesRead = 0;

                        @Override
                        public int read() throws IOException {
                            if (++this.bytesRead > numBytes) {
                                return -1;
                            }
                            return 0xFF & buffer.getByte();
                        }
                    });
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[8192];
                    while ((len = ((InputStream)in).read(bytes)) > 0) {
                        baos.write(bytes, 0, len);
                    }
                    return new String(baos.toByteArray(), "UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };


        public abstract byte[] compress(String var1);

        public abstract String decompress(ScanBuffer var1, int var2);

        public int getId() {
            return this.ordinal();
        }

        public static CompressionType getFromId(int id) {
            for (CompressionType ct : CompressionType.values()) {
                if (ct.getId() != id) continue;
                return ct;
            }
            throw new IllegalArgumentException("Unknown compressor type for id: " + id);
        }
    }
}

