/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.log;

import com.google.common.base.Preconditions;
import java.time.Instant;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.janusgraph.core.log.TransactionId;

public class StandardTransactionId
implements TransactionId {
    private String instanceId;
    private long transactionId;
    private Instant transactionTime;

    public StandardTransactionId(String instanceId, long transactionId, Instant transactionTime) {
        Preconditions.checkArgument((instanceId != null && transactionId >= 0L && transactionTime != null ? 1 : 0) != 0);
        this.instanceId = instanceId;
        this.transactionId = transactionId;
        this.transactionTime = transactionTime;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Instant getTransactionTime() {
        return this.transactionTime;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.instanceId).append(this.transactionId).append((Object)this.transactionTime).toHashCode();
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        StandardTransactionId id = (StandardTransactionId)oth;
        return this.instanceId.equals(id.instanceId) && this.transactionId == id.transactionId && this.transactionTime.equals(id.transactionTime);
    }

    public String toString() {
        return this.transactionId + "@" + this.instanceId + "::" + this.transactionTime;
    }
}

