/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.management;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.management.ConfigurationManagementGraph;
import org.janusgraph.graphdb.management.utils.JanusGraphManagerException;

public class JanusGraphManager
implements GraphManager {
    public static final String JANUS_GRAPH_MANAGER_EXPECTED_STATE_MSG = "Gremlin Server must be configured to use the JanusGraphManager.";
    private final Map<String, Graph> graphs = new ConcurrentHashMap<String, Graph>();
    private final Map<String, TraversalSource> traversalSources = new ConcurrentHashMap<String, TraversalSource>();
    private Settings settings = null;
    private final Object instantiateGraphLock = new Object();
    private static JanusGraphManager instance = null;
    private static final String CONFIGURATION_MANAGEMENT_GRAPH_KEY = ConfigurationManagementGraph.class.getSimpleName();

    public JanusGraphManager(Settings settings) {
        this.initialize();
        this.settings = settings;
        settings.graphs.forEach((key, value) -> {
            StandardJanusGraph graph = (StandardJanusGraph)JanusGraphFactory.open(value, key);
            if (key.toLowerCase().equals(CONFIGURATION_MANAGEMENT_GRAPH_KEY.toLowerCase())) {
                new ConfigurationManagementGraph(graph);
            }
        });
    }

    private synchronized void initialize() {
        if (null != instance) {
            String errMsg = "You may not instantiate a JanusGraphManager. The single instance should be handled by Tinkerpop's GremlinServer startup processes.";
            throw new JanusGraphManagerException("You may not instantiate a JanusGraphManager. The single instance should be handled by Tinkerpop's GremlinServer startup processes.");
        }
        instance = this;
    }

    public static JanusGraphManager getInstance() {
        return instance;
    }

    public static JanusGraphManager getInstance(boolean forceCreate) {
        if (forceCreate) {
            return new JanusGraphManager(new Settings());
        }
        return instance;
    }

    @Deprecated
    public Map getGraphs() {
        return this.graphs;
    }

    public Set<String> getGraphNames() {
        return this.graphs.keySet();
    }

    public Graph getGraph(String gName) {
        return this.graphs.get(gName);
    }

    public void putGraph(String gName, Graph g) {
        this.graphs.put(gName, g);
    }

    public Map<String, TraversalSource> getTraversalSources() {
        return this.traversalSources;
    }

    public Set<String> getTraversalSourceNames() {
        return this.traversalSources.keySet();
    }

    public TraversalSource getTraversalSource(String tsName) {
        return this.traversalSources.get(tsName);
    }

    public void putTraversalSource(String tsName, TraversalSource ts) {
        this.traversalSources.put(tsName, ts);
    }

    public TraversalSource removeTraversalSource(String tsName) {
        if (tsName == null) {
            return null;
        }
        return this.traversalSources.remove(tsName);
    }

    public Bindings getAsBindings() {
        SimpleBindings bindings = new SimpleBindings();
        this.graphs.forEach(bindings::put);
        return bindings;
    }

    public void rollbackAll() {
        this.graphs.forEach((key, value) -> {
            Graph graph = value;
            if (graph.tx().isOpen()) {
                graph.tx().rollback();
            }
        });
    }

    public void rollback(Set<String> graphSourceNamesToCloseTxOn) {
        this.commitOrRollback(graphSourceNamesToCloseTxOn, false);
    }

    public void commitAll() {
        this.graphs.forEach((key, value) -> {
            Graph graph = value;
            if (graph.tx().isOpen()) {
                graph.tx().commit();
            }
        });
    }

    public void commit(Set<String> graphSourceNamesToCloseTxOn) {
        this.commitOrRollback(graphSourceNamesToCloseTxOn, true);
    }

    public void commitOrRollback(Set<String> graphSourceNamesToCloseTxOn, Boolean commit) {
        graphSourceNamesToCloseTxOn.forEach(e -> {
            Graph graph = this.getGraph((String)e);
            if (null != graph) {
                this.closeTx(graph, commit);
            }
        });
    }

    public void closeTx(Graph graph, Boolean commit) {
        if (graph.tx().isOpen()) {
            if (commit.booleanValue()) {
                graph.tx().commit();
            } else {
                graph.tx().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph openGraph(String gName, Function<String, Graph> thunk) {
        Graph graph = this.graphs.get(gName);
        if (graph != null && !((StandardJanusGraph)graph).isClosed()) {
            return graph;
        }
        Object object = this.instantiateGraphLock;
        synchronized (object) {
            graph = this.graphs.get(gName);
            if (graph == null || ((StandardJanusGraph)graph).isClosed()) {
                graph = thunk.apply(gName);
                this.graphs.put(gName, graph);
            }
        }
        return graph;
    }

    public Graph removeGraph(String gName) {
        if (gName == null) {
            return null;
        }
        return this.graphs.remove(gName);
    }
}

