/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.graphdb.olap.computer.FulgoraUtil;
import org.janusgraph.graphdb.olap.computer.FulgoraVertexMemory;
import org.janusgraph.graphdb.olap.computer.FulgoraVertexProperty;
import org.janusgraph.graphdb.vertices.PreloadedVertex;

class VertexMemoryHandler<M>
implements PreloadedVertex.PropertyMixing,
Messenger<M> {
    protected final FulgoraVertexMemory<M> vertexMemory;
    private final PreloadedVertex vertex;
    protected final long vertexId;
    private boolean inExecute;

    VertexMemoryHandler(FulgoraVertexMemory<M> vertexMemory, PreloadedVertex vertex) {
        assert (vertex != null && vertexMemory != null);
        this.vertexMemory = vertexMemory;
        this.vertex = vertex;
        this.vertexId = vertexMemory.getCanonicalId(vertex.longId());
        this.inExecute = false;
    }

    void removeKey(String key) {
        this.vertexMemory.setProperty(this.vertexId, key, null);
    }

    <V> JanusGraphVertexProperty<V> constructProperty(String key, V value) {
        assert (key != null && value != null);
        return new FulgoraVertexProperty<V>(this, this.vertex, key, value);
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        Set<String> memoryKeys = this.vertexMemory.getMemoryKeys();
        if (memoryKeys.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (keys == null || keys.length == 0) {
            keys = (String[])memoryKeys.stream().filter(k -> !k.equals("gremlin.traversalVertexProgram.haltedTraversers")).toArray(String[]::new);
        }
        ArrayList result = new ArrayList(Math.min(keys.length, memoryKeys.size()));
        for (String key : keys) {
            Object value;
            if (!this.supports(key) || (value = this.vertexMemory.getProperty(this.vertexId, key)) == null) continue;
            result.add(this.constructProperty(key, value));
        }
        return result.iterator();
    }

    @Override
    public boolean supports(String key) {
        return this.vertexMemory.getMemoryKeys().contains(key);
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value) {
        if (!this.supports(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAnElementComputeKey((String)key);
        }
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        if (cardinality == VertexProperty.Cardinality.single) {
            this.vertexMemory.setProperty(this.vertexId, key, value);
        } else {
            ArrayList<V> values;
            Object previousValue = this.vertexMemory.getProperty(this.vertexId, key);
            if (previousValue != null) {
                assert (previousValue instanceof List);
                values = new ArrayList((List)previousValue);
            } else {
                values = new ArrayList<V>();
            }
            values.add(value);
            this.vertexMemory.setProperty(this.vertexId, key, values);
        }
        return this.constructProperty(key, value);
    }

    public boolean isInExecute() {
        return this.inExecute;
    }

    public void setInExecute(boolean inExecute) {
        this.inExecute = inExecute;
    }

    public Stream<M> receiveMessages(MessageScope messageScope) {
        List edges;
        if (messageScope instanceof MessageScope.Global) {
            M message = this.vertexMemory.getMessage(this.vertexId, messageScope);
            if (message == null) {
                return Stream.empty();
            }
            return Stream.of(message);
        }
        MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
        BiFunction edgeFct = localMessageScope.getEdgeFunction();
        try (Traversal<Vertex, Edge> reverseIncident = FulgoraUtil.getReverseElementTraversal(localMessageScope, this.vertex, this.vertex.tx());){
            edges = IteratorUtils.list(reverseIncident);
        }
        catch (Exception e2) {
            throw new JanusGraphException("Unable to close traversal", e2);
        }
        return edges.stream().map(e -> {
            M msg = this.vertexMemory.getMessage(this.vertexMemory.getCanonicalId(((JanusGraphEdge)e).otherVertex(this.vertex).longId()), (MessageScope)localMessageScope);
            return msg == null ? null : edgeFct.apply(msg, e);
        }).filter(m -> m != null);
    }

    public Iterator<M> receiveMessages() {
        Stream<Object> combinedStream = Stream.empty();
        for (MessageScope scope : this.vertexMemory.getPreviousScopes()) {
            combinedStream = Stream.concat(this.receiveMessages(scope), combinedStream);
        }
        return combinedStream.iterator();
    }

    public void sendMessage(MessageScope messageScope, M m) {
        if (messageScope instanceof MessageScope.Local) {
            this.vertexMemory.sendMessage(this.vertexId, m, messageScope);
        } else {
            ((MessageScope.Global)messageScope).vertices().forEach(v -> {
                long vertexId = v instanceof JanusGraphVertex ? ((JanusGraphVertex)v).longId() : ((Long)v.id()).longValue();
                this.vertexMemory.sendMessage(this.vertexMemory.getCanonicalId(vertexId), m, messageScope);
            });
        }
    }

    static class Partition<M>
    extends VertexMemoryHandler<M> {
        Partition(FulgoraVertexMemory<M> vertexMemory, PreloadedVertex vertex) {
            super(vertexMemory, vertex);
        }

        @Override
        public Stream<M> receiveMessages(MessageScope messageScope) {
            if (messageScope instanceof MessageScope.Global) {
                return super.receiveMessages(messageScope);
            }
            MessageScope.Local localMessageScope = (MessageScope.Local)messageScope;
            Object aggregateMsg = this.vertexMemory.getAggregateMessage(this.vertexId, (MessageScope)localMessageScope);
            if (aggregateMsg == null) {
                return Stream.empty();
            }
            return Stream.of(aggregateMsg);
        }
    }
}

