/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.StandardTransactionBuilder;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.util.datastructures.Retriever;

public class GhostVertexRemover
extends VertexJobConverter {
    private static final int RELATION_COUNT_LIMIT = 10000;
    private static final SliceQuery EVERYTHING_QUERY = new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(4));
    public static final String REMOVED_RELATION_COUNT = "removed-relations";
    public static final String REMOVED_VERTEX_COUNT = "removed-vertices";
    public static final String SKIPPED_GHOST_LIMIT_COUNT = "skipped-ghosts";
    private final SliceQuery everythingQueryLimit = EVERYTHING_QUERY.updateLimit(10000);
    private Instant jobStartTime;

    public GhostVertexRemover(JanusGraph graph) {
        super(graph, new NoOpJob());
    }

    public GhostVertexRemover() {
        this((JanusGraph)null);
    }

    protected GhostVertexRemover(GhostVertexRemover copy) {
        super(copy);
    }

    @Override
    public GhostVertexRemover clone() {
        return new GhostVertexRemover(this);
    }

    @Override
    public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
        super.workerIterationStart(jobConfig, graphConfig, metrics);
        Preconditions.checkArgument((boolean)jobConfig.has(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]), (Object)"Invalid configuration for this job. Start time is required.");
        this.jobStartTime = Instant.ofEpochMilli(jobConfig.get(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]));
        assert (this.tx != null && this.tx.isOpen());
        this.tx.rollback();
        StandardTransactionBuilder txb = this.graph.get().buildTransaction();
        txb.commitTime(this.jobStartTime);
        txb.checkExternalVertexExistence(false);
        txb.checkInternalVertexExistence(false);
        this.tx = (StandardJanusGraphTx)txb.start();
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        long vertexId = this.getVertexId(key);
        assert (entries.size() == 1);
        assert (entries.get(this.everythingQueryLimit) != null);
        final EntryList everything = entries.get(this.everythingQueryLimit);
        if (!this.isGhostVertex(vertexId, everything)) {
            return;
        }
        if (everything.size() >= 10000) {
            metrics.incrementCustom(SKIPPED_GHOST_LIMIT_COUNT);
            return;
        }
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof CacheVertex), (Object)"The bounding transaction is not configured correctly");
        CacheVertex v = (CacheVertex)vertex;
        v.loadRelations(EVERYTHING_QUERY, new Retriever<SliceQuery, EntryList>(){

            @Override
            public EntryList get(SliceQuery input) {
                return everything;
            }
        });
        int removedRelations = 0;
        Iterator<JanusGraphRelation> iter = ((VertexCentricQueryBuilder)v.query().noPartitionRestriction()).relations().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
            ++removedRelations;
        }
        metrics.incrementCustom(REMOVED_VERTEX_COUNT);
        metrics.incrementCustom(REMOVED_RELATION_COUNT, removedRelations);
    }

    @Override
    public List<SliceQuery> getQueries() {
        return ImmutableList.of((Object)this.everythingQueryLimit);
    }

    private static class NoOpJob
    implements VertexScanJob {
        private NoOpJob() {
        }

        @Override
        public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getQueries(QueryContainer queries) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NoOpJob clone() {
            return this;
        }
    }
}

