/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResultMergeSortIterator<R>
implements Iterator<R> {
    private final Iterator<R> first;
    private final Iterator<R> second;
    private final Comparator<R> comp;
    private final boolean filterDuplicates;
    private R nextFirst;
    private R nextSecond;
    private R next;

    public ResultMergeSortIterator(Iterator<R> first, Iterator<R> second, Comparator<R> comparator, boolean filterDuplicates) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        Preconditions.checkNotNull(comparator);
        this.first = first;
        this.second = second;
        this.comp = comparator;
        this.filterDuplicates = filterDuplicates;
        this.nextFirst = null;
        this.nextSecond = null;
        this.next = this.nextInternal();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R current = this.next;
        this.next = null;
        do {
            this.next = this.nextInternal();
        } while (this.next != null && this.filterDuplicates && this.comp.compare(current, this.next) == 0);
        return current;
    }

    public R nextInternal() {
        if (this.nextFirst == null && this.first.hasNext()) {
            this.nextFirst = this.first.next();
            assert (this.nextFirst != null);
        }
        if (this.nextSecond == null && this.second.hasNext()) {
            this.nextSecond = this.second.next();
            assert (this.nextSecond != null);
        }
        R result = null;
        if (this.nextFirst == null && this.nextSecond == null) {
            return null;
        }
        if (this.nextFirst == null) {
            result = this.nextSecond;
            this.nextSecond = null;
        } else if (this.nextSecond == null) {
            result = this.nextFirst;
            this.nextFirst = null;
        } else {
            int c = this.comp.compare(this.nextFirst, this.nextSecond);
            if (c <= 0) {
                result = this.nextFirst;
                this.nextFirst = null;
            } else {
                result = this.nextSecond;
                this.nextSecond = null;
            }
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <R> Iterable<R> mergeSort(final Iterable<R> first, final Iterable<R> second, final Comparator<R> comparator, final boolean filterDuplicates) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new ResultMergeSortIterator(first.iterator(), second.iterator(), comparator, filterDuplicates);
            }
        };
    }
}

