/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractVertexProperty;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class CacheVertexProperty
extends AbstractVertexProperty {
    private final Entry data;

    public CacheVertexProperty(long id, PropertyKey key, InternalVertex start, Object value, Entry data) {
        super(id, key, start.it(), value);
        this.data = data;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            final long id = super.longId();
            it = (InternalRelation)Iterables.getOnlyElement(startVertex.getAddedRelations(new Predicate<InternalRelation>(){

                public boolean apply(@Nullable InternalRelation internalRelation) {
                    return internalRelation instanceof StandardVertexProperty && ((StandardVertexProperty)internalRelation).getPreviousID() == id;
                }
            }), null);
        }
        return it != null ? it : super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            PropertyKey type = this.tx().getExistingPropertyKey(entry.key);
            if (type instanceof ImplicitKey) continue;
            to.setPropertyDirect(type, entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardVertexProperty copy = new StandardVertexProperty(super.longId(), this.propertyKey(), this.getVertex(0), this.value(), 2);
        this.copyProperties(copy);
        copy.remove();
        StandardVertexProperty u = (StandardVertexProperty)this.tx().addProperty(this.getVertex(0), this.propertyKey(), this.value());
        if (this.type.getConsistencyModifier() != ConsistencyModifier.FORK) {
            u.setId(super.longId());
        }
        u.setPreviousID(super.longId());
        this.copyProperties(u);
        return u;
    }

    @Override
    public long longId() {
        InternalRelation it = this.it();
        return it == this ? super.longId() : it.longId();
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = RelationConstructor.readRelationCache(this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getValueDirect(PropertyKey key) {
        return this.getPropertyMap().get(key.longId());
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<PropertyKey> types = new ArrayList<PropertyKey>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingPropertyKey(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(PropertyKey key, Object value) {
        this.update().setPropertyDirect(key, value);
    }

    @Override
    public <O> O removePropertyDirect(PropertyKey key) {
        return this.update().removePropertyDirect(key);
    }

    @Override
    public byte getLifeCycle() {
        if ((this.getVertex(0).hasRemovedRelations() || this.getVertex(0).isRemoved()) && this.tx().isRemovedRelation(super.longId())) {
            return 6;
        }
        return 2;
    }

    @Override
    public void remove() {
        if (!this.tx().isRemovedRelation(super.longId())) {
            this.tx().removeRelation(this);
        }
    }
}

