/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.AbstractElement;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class RelationComparator
implements Comparator<InternalRelation> {
    private final StandardJanusGraphTx tx;
    private final InternalVertex vertex;
    private final OrderList orders;

    public RelationComparator(InternalVertex v) {
        this(v, OrderList.NO_ORDER);
    }

    public RelationComparator(InternalVertex v, OrderList orders) {
        Preconditions.checkArgument((v != null && orders != null ? 1 : 0) != 0);
        this.vertex = v;
        this.tx = v.tx();
        this.orders = orders;
    }

    @Override
    public int compare(InternalRelation r1, InternalRelation r2) {
        int i;
        InternalRelationType t2;
        int reltypecompare;
        if (r1.equals(r2)) {
            return 0;
        }
        if (!this.orders.isEmpty()) {
            for (OrderList.OrderEntry order : this.orders) {
                int orderCompare = this.compareOnKey((JanusGraphRelation)r1, (JanusGraphRelation)r2, order.getKey(), order.getOrder());
                if (orderCompare == 0) continue;
                return orderCompare;
            }
        }
        if ((reltypecompare = (r1.isProperty() ? 1 : 2) - (r2.isProperty() ? 1 : 2)) != 0) {
            return reltypecompare;
        }
        InternalRelationType t1 = (InternalRelationType)r1.getType();
        int typecompare = AbstractElement.compare(t1, t2 = (InternalRelationType)r2.getType());
        if (typecompare != 0) {
            return typecompare;
        }
        assert (t1.equals(t2));
        Direction dir1 = null;
        Direction dir2 = null;
        for (i = 0; i < r1.getLen(); ++i) {
            if (!r1.getVertex(i).equals(this.vertex)) continue;
            dir1 = EdgeDirection.fromPosition(i);
            break;
        }
        for (i = 0; i < r2.getLen(); ++i) {
            if (!r2.getVertex(i).equals(this.vertex)) continue;
            dir2 = EdgeDirection.fromPosition(i);
            break;
        }
        assert (dir1 != null && dir2 != null);
        int dirCompare = EdgeDirection.position(dir1) - EdgeDirection.position(dir2);
        if (dirCompare != 0) {
            return dirCompare;
        }
        if (t1.multiplicity().isUnique(dir1)) {
            return 0;
        }
        for (long typeid : t1.getSortKey()) {
            int keycompare = this.compareOnKey((JanusGraphRelation)r1, (JanusGraphRelation)r2, typeid, t1.getSortOrder());
            if (keycompare == 0) continue;
            return keycompare;
        }
        if (r1.isProperty()) {
            Object o1 = ((JanusGraphVertexProperty)((Object)r1)).value();
            Object o2 = ((JanusGraphVertexProperty)((Object)r2)).value();
            Preconditions.checkArgument((o1 != null && o2 != null ? 1 : 0) != 0);
            if (!o1.equals(o2)) {
                int objectcompare = 0;
                objectcompare = Comparable.class.isAssignableFrom(((PropertyKey)((Object)t1)).dataType()) ? ((Comparable)o1).compareTo(o2) : System.identityHashCode(o1) - System.identityHashCode(o2);
                if (objectcompare != 0) {
                    return objectcompare;
                }
            }
        } else {
            Preconditions.checkArgument((r1.isEdge() && r2.isEdge() ? 1 : 0) != 0);
            int vertexcompare = AbstractElement.compare(r1.getVertex(EdgeDirection.position(dir1.opposite())), r2.getVertex(EdgeDirection.position(dir1.opposite())));
            if (vertexcompare != 0) {
                return vertexcompare;
            }
        }
        if (t1.multiplicity().isConstrained()) {
            return 0;
        }
        return AbstractElement.compare(r1, r2);
    }

    public static int compareValues(Object v1, Object v2, Order order) {
        return RelationComparator.compareValues(v1, v2) * (order == Order.DESC ? -1 : 1);
    }

    public static int compareValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            if (v1 != null) {
                return -1;
            }
            if (v2 != null) {
                return 1;
            }
            return 0;
        }
        Preconditions.checkArgument((v1 instanceof Comparable && v2 instanceof Comparable ? 1 : 0) != 0, (Object)"Encountered invalid values");
        return ((Comparable)v1).compareTo(v2);
    }

    private int compareOnKey(JanusGraphRelation r1, JanusGraphRelation r2, long typeid, Order order) {
        return this.compareOnKey(r1, r2, this.tx.getExistingPropertyKey(typeid), order);
    }

    private int compareOnKey(JanusGraphRelation r1, JanusGraphRelation r2, PropertyKey type, Order order) {
        Object v1 = r1.valueOrNull(type);
        Object v2 = r2.valueOrNull(type);
        return RelationComparator.compareValues(v1, v2, order);
    }
}

