/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.schema;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.schema.EdgeLabelDefinition;
import org.janusgraph.graphdb.schema.PropertyKeyDefinition;
import org.janusgraph.graphdb.schema.RelationTypeDefinition;
import org.janusgraph.graphdb.schema.SchemaProvider;
import org.janusgraph.graphdb.schema.VertexLabelDefinition;

public class SchemaContainer
implements SchemaProvider {
    private final Map<String, VertexLabelDefinition> vertexLabels = Maps.newHashMap();
    private final Map<String, RelationTypeDefinition> relationTypes = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaContainer(JanusGraph graph) {
        JanusGraphManagement mgmt = graph.openManagement();
        try {
            for (VertexLabel vl : mgmt.getVertexLabels()) {
                VertexLabelDefinition vld = new VertexLabelDefinition(vl);
                this.vertexLabels.put(vld.getName(), vld);
            }
            for (EdgeLabel el : mgmt.getRelationTypes(EdgeLabel.class)) {
                EdgeLabelDefinition eld = new EdgeLabelDefinition(el);
                this.relationTypes.put(eld.getName(), eld);
            }
            for (PropertyKey pk : mgmt.getRelationTypes(PropertyKey.class)) {
                PropertyKeyDefinition pkd = new PropertyKeyDefinition(pk);
                this.relationTypes.put(pkd.getName(), pkd);
            }
        }
        finally {
            mgmt.rollback();
        }
    }

    public Iterable<VertexLabelDefinition> getVertexLabels() {
        return this.vertexLabels.values();
    }

    @Override
    public VertexLabelDefinition getVertexLabel(String name) {
        return this.vertexLabels.get(name);
    }

    public boolean containsVertexLabel(String name) {
        return this.getVertexLabel(name) != null;
    }

    public Iterable<PropertyKeyDefinition> getPropertyKeys() {
        return Iterables.filter(this.relationTypes.values(), PropertyKeyDefinition.class);
    }

    public Iterable<EdgeLabelDefinition> getEdgeLabels() {
        return Iterables.filter(this.relationTypes.values(), EdgeLabelDefinition.class);
    }

    @Override
    public RelationTypeDefinition getRelationType(String name) {
        return this.relationTypes.get(name);
    }

    public boolean containsRelationType(String name) {
        return this.getRelationType(name) != null;
    }

    @Override
    public EdgeLabelDefinition getEdgeLabel(String name) {
        RelationTypeDefinition def = this.getRelationType(name);
        if (def != null && !(def instanceof EdgeLabelDefinition)) {
            throw new IllegalArgumentException("Not an edge label but property key: " + name);
        }
        return (EdgeLabelDefinition)def;
    }

    @Override
    public PropertyKeyDefinition getPropertyKey(String name) {
        RelationTypeDefinition def = this.getRelationType(name);
        if (def != null && !(def instanceof PropertyKeyDefinition)) {
            throw new IllegalArgumentException("Not a property key but edge label: " + name);
        }
        return (PropertyKeyDefinition)def;
    }
}

