/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexFilterOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueriable;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphLocalQueryOptimizerStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphLocalQueryOptimizerStrategy INSTANCE = new JanusGraphLocalQueryOptimizerStrategy();
    private static final List<Class<? extends Step>> MULTIQUERY_INCOMPATIBLE_STEPS = Arrays.asList(RepeatStep.class, MatchStep.class, BranchStep.class);
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(AdjacentVertexFilterOptimizerStrategy.class);

    private JanusGraphLocalQueryOptimizerStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        Graph graph = (Graph)traversal.getGraph().get();
        StandardJanusGraph janusGraph = graph instanceof StandardJanusGraphTx ? ((StandardJanusGraphTx)graph).getGraph() : (StandardJanusGraph)graph;
        boolean useMultiQuery = !TraversalHelper.onGraphComputer(traversal) && janusGraph.getConfiguration().useMultiQuery();
        TraversalHelper.getStepsOfClass(VertexStep.class, traversal).forEach(originalStep -> {
            JanusGraphVertexStep vstep = new JanusGraphVertexStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vstep, (Traversal.Admin)traversal);
            if (JanusGraphTraversalUtil.isEdgeReturnStep(vstep)) {
                HasStepFolder.foldInHasContainer(vstep, traversal);
            }
            assert (JanusGraphTraversalUtil.isEdgeReturnStep(vstep) || JanusGraphTraversalUtil.isVertexReturnStep(vstep));
            Step nextStep = JanusGraphTraversalUtil.getNextNonIdentityStep(vstep);
            if (nextStep instanceof RangeGlobalStep) {
                int limit = QueryUtil.convertLimit(((RangeGlobalStep)nextStep).getHighRange());
                vstep.setLimit(QueryUtil.mergeLimits(limit, vstep.getLimit()));
            }
            if (useMultiQuery && !JanusGraphLocalQueryOptimizerStrategy.isChildOf(vstep, MULTIQUERY_INCOMPATIBLE_STEPS)) {
                vstep.setUseMultiQuery(true);
            }
        });
        TraversalHelper.getStepsOfClass(PropertiesStep.class, traversal).forEach(originalStep -> {
            JanusGraphPropertiesStep vstep = new JanusGraphPropertiesStep(originalStep);
            TraversalHelper.replaceStep((Step)originalStep, vstep, (Traversal.Admin)traversal);
            if (vstep.getReturnType().forProperties()) {
                HasStepFolder.foldInHasContainer(vstep, traversal);
            }
            if (useMultiQuery && !JanusGraphLocalQueryOptimizerStrategy.isChildOf(vstep, MULTIQUERY_INCOMPATIBLE_STEPS)) {
                vstep.setUseMultiQuery(true);
            }
        });
        TraversalHelper.getStepsOfClass(LocalStep.class, traversal).forEach(localStep -> {
            HasStepFolder vstep;
            Traversal.Admin localTraversal = (Traversal.Admin)localStep.getLocalChildren().get(0);
            Step localStart = localTraversal.getStartStep();
            if (localStart instanceof VertexStep) {
                vstep = new JanusGraphVertexStep((VertexStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, vstep, (Traversal.Admin)localTraversal);
                if (JanusGraphTraversalUtil.isEdgeReturnStep(vstep)) {
                    HasStepFolder.foldInHasContainer(vstep, localTraversal);
                    HasStepFolder.foldInOrder(vstep, localTraversal, traversal, false);
                }
                HasStepFolder.foldInRange(vstep, localTraversal);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vstep, useMultiQuery);
            }
            if (localStart instanceof PropertiesStep) {
                vstep = new JanusGraphPropertiesStep((PropertiesStep)localStart);
                TraversalHelper.replaceStep((Step)localStart, vstep, (Traversal.Admin)localTraversal);
                if (vstep.getReturnType().forProperties()) {
                    HasStepFolder.foldInHasContainer(vstep, localTraversal);
                    HasStepFolder.foldInOrder(vstep, localTraversal, traversal, false);
                }
                HasStepFolder.foldInRange(vstep, localTraversal);
                JanusGraphLocalQueryOptimizerStrategy.unfoldLocalTraversal(traversal, localStep, localTraversal, vstep, useMultiQuery);
            }
        });
    }

    private static void unfoldLocalTraversal(Traversal.Admin<?, ?> traversal, LocalStep<?, ?> localStep, Traversal.Admin localTraversal, MultiQueriable vstep, boolean useMultiQuery) {
        assert (localTraversal.asAdmin().getSteps().size() > 0);
        if (localTraversal.asAdmin().getSteps().size() == 1) {
            assert (localTraversal.getStartStep() == vstep);
            vstep.setTraversal(traversal);
            TraversalHelper.replaceStep(localStep, (Step)vstep, traversal);
            if (useMultiQuery && !JanusGraphLocalQueryOptimizerStrategy.isChildOf(vstep, MULTIQUERY_INCOMPATIBLE_STEPS)) {
                vstep.setUseMultiQuery(true);
            }
        }
    }

    private static boolean isChildOf(Step<?, ?> currentStep, List<Class<? extends Step>> stepClasses) {
        Step parent = currentStep.getTraversal().getParent().asStep();
        while (!parent.equals(EmptyStep.instance())) {
            Step p = parent;
            if (stepClasses.stream().filter(stepClass -> stepClass.isInstance(p)).findFirst().isPresent()) {
                return true;
            }
            parent = parent.getTraversal().getParent().asStep();
        }
        return false;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphLocalQueryOptimizerStrategy instance() {
        return INSTANCE;
    }
}

