/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.ParameterType;

public class ParameterIndexField
extends IndexField {
    private final Parameter[] parameters;

    private ParameterIndexField(PropertyKey key, Parameter[] parameters) {
        super(key);
        Preconditions.checkNotNull((Object)parameters);
        this.parameters = parameters;
    }

    public SchemaStatus getStatus() {
        SchemaStatus status = ParameterType.STATUS.findParameter(this.parameters, null);
        Preconditions.checkState((status != null ? 1 : 0) != 0, (String)"Field [%s] did not have a status", (Object[])new Object[]{this});
        return status;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public static ParameterIndexField of(PropertyKey key, Parameter ... parameters) {
        return new ParameterIndexField(key, parameters);
    }
}

