/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;

public class VertexLabelVertex
extends JanusGraphSchemaVertex
implements InternalVertexLabel {
    private Integer ttl = null;

    public VertexLabelVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public boolean isPartitioned() {
        return this.getDefinition().getValue(TypeDefinitionCategory.PARTITIONED, Boolean.class);
    }

    @Override
    public boolean isStatic() {
        return this.getDefinition().getValue(TypeDefinitionCategory.STATIC, Boolean.class);
    }

    @Override
    public boolean hasDefaultConfiguration() {
        return !this.isPartitioned() && !this.isStatic();
    }

    @Override
    public int getTTL() {
        if (null == this.ttl) {
            this.ttl = TypeUtil.getTTL(this);
        }
        return this.ttl;
    }
}

