/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Token;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public abstract class SystemTypeManager {
    private static volatile Map<Long, SystemRelationType> SYSTEM_TYPES_BY_ID;
    private static volatile Map<String, SystemRelationType> SYSTEM_TYPES_BY_NAME;
    private static final Set<String> ADDITIONAL_RESERVED_NAMES;
    private static final char[] RESERVED_CHARS;

    public static SystemRelationType getSystemType(long id) {
        return SYSTEM_TYPES_BY_ID.get(id);
    }

    public static SystemRelationType getSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.get(name);
    }

    public static boolean isNotSystemName(JanusGraphSchemaCategory category, String name) {
        TypeUtil.checkTypeName(category, name);
        if (SystemTypeManager.isSystemType(name.toLowerCase()) || Token.isSystemName(name)) {
            throw new IllegalArgumentException("Name cannot be in protected namespace: " + name);
        }
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf(c), name});
        }
        return true;
    }

    public static boolean isSystemType(String name) {
        return SYSTEM_TYPES_BY_NAME.containsKey(name) || ADDITIONAL_RESERVED_NAMES.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        RESERVED_CHARS = new char[]{'{', '}', '\"', '\u001e'};
        Class<SystemTypeManager> clazz = SystemTypeManager.class;
        synchronized (SystemTypeManager.class) {
            ImmutableMap.Builder idBuilder = ImmutableMap.builder();
            ImmutableMap.Builder nameBuilder = ImmutableMap.builder();
            for (SystemRelationType et : new SystemRelationType[]{BaseKey.SchemaCategory, BaseKey.SchemaDefinitionDesc, BaseKey.SchemaDefinitionProperty, BaseKey.SchemaName, BaseKey.SchemaUpdateTime, BaseKey.VertexExists, BaseLabel.VertexLabelEdge, BaseLabel.SchemaDefinitionEdge, ImplicitKey.ID, ImplicitKey.JANUSGRAPHID, ImplicitKey.LABEL, ImplicitKey.KEY, ImplicitKey.VALUE, ImplicitKey.ADJACENT_ID, ImplicitKey.TIMESTAMP, ImplicitKey.TTL, ImplicitKey.VISIBILITY}) {
                idBuilder.put((Object)et.longId(), (Object)et);
                nameBuilder.put((Object)et.name(), (Object)et);
            }
            SYSTEM_TYPES_BY_ID = idBuilder.build();
            SYSTEM_TYPES_BY_NAME = nameBuilder.build();
            ADDITIONAL_RESERVED_NAMES = ImmutableSet.of((Object)"key", (Object)"vertex", (Object)"edge", (Object)"element", (Object)"property", (Object)"label", (Object[])new String[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            assert (SYSTEM_TYPES_BY_ID.size() == 17);
            assert (SYSTEM_TYPES_BY_NAME.size() == 17);
            return;
        }
    }
}

