/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.vertices;

import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.vertices.StandardVertex;
import org.janusgraph.util.datastructures.Retriever;

public class CacheVertex
extends StandardVertex {
    protected final Map<SliceQuery, EntryList> queryCache = new HashMap<SliceQuery, EntryList>(4);

    public CacheVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToQueryCache(SliceQuery query, EntryList entries) {
        Map<SliceQuery, EntryList> map = this.queryCache;
        synchronized (map) {
            this.queryCache.put(query, entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getQueryCacheSize() {
        Map<SliceQuery, EntryList> map = this.queryCache;
        synchronized (map) {
            return this.queryCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryList loadRelations(SliceQuery query, Retriever<SliceQuery, EntryList> lookup) {
        EntryList result;
        if (this.isNew()) {
            return EntryList.EMPTY_LIST;
        }
        Map<SliceQuery, EntryList> map = this.queryCache;
        synchronized (map) {
            result = this.queryCache.get(query);
        }
        if (result == null) {
            Map.Entry<SliceQuery, EntryList> superset = this.getSuperResultSet(query);
            result = superset == null ? lookup.get(query) : query.getSubset(superset.getKey(), superset.getValue());
            this.addToQueryCache(query, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        Map<SliceQuery, EntryList> map = this.queryCache;
        synchronized (map) {
            return this.queryCache.get(query) != null || this.getSuperResultSet(query) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<SliceQuery, EntryList> getSuperResultSet(SliceQuery query) {
        Map<SliceQuery, EntryList> map = this.queryCache;
        synchronized (map) {
            if (this.queryCache.size() > 0) {
                for (Map.Entry<SliceQuery, EntryList> entry : this.queryCache.entrySet()) {
                    if (!entry.getKey().subsumes(query)) continue;
                    return entry;
                }
            }
        }
        return null;
    }
}

