/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.janusgraph.util.datastructures.Interval;
import org.janusgraph.util.datastructures.RangeInterval;

public class PointInterval<T>
implements Interval<T> {
    private final Set<T> points;

    private PointInterval(Set<T> points) {
        this.points = points;
    }

    public PointInterval(T point) {
        this.points = new HashSet<T>(1);
        this.points.add(point);
    }

    public PointInterval(T ... points) {
        this((Iterable<T>)Arrays.asList(points));
    }

    public PointInterval(Iterable<T> points) {
        this.points = new HashSet<T>(4);
        Iterables.addAll(this.points, points);
    }

    @Override
    public Collection<T> getPoints() {
        return this.points;
    }

    public void setPoint(T point) {
        this.points.clear();
        this.points.add(point);
    }

    public void addPoint(T point) {
        this.points.add(point);
    }

    @Override
    public T getStart() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0, (Object)"There are no points in this interval");
        return Collections.min(this.points, ComparableComparator.getInstance());
    }

    @Override
    public T getEnd() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0, (Object)"There are no points in this interval");
        return Collections.max(this.points, ComparableComparator.getInstance());
    }

    @Override
    public boolean startInclusive() {
        return true;
    }

    @Override
    public boolean endInclusive() {
        return true;
    }

    @Override
    public boolean isPoints() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public Interval<T> intersect(Interval<T> other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0);
        if (other instanceof PointInterval) {
            Sets.newHashSet(this.points);
            this.points.retainAll(((PointInterval)other).points);
            return new PointInterval<Set<T>>(this.points);
        }
        if (other instanceof RangeInterval) {
            final RangeInterval rint = (RangeInterval)other;
            return new PointInterval<HashSet>(Sets.newHashSet((Iterable)Iterables.filter(this.points, (Predicate)new Predicate<T>(){

                public boolean apply(@Nullable T t) {
                    return rint.containsPoint(t);
                }
            })));
        }
        throw new AssertionError((Object)("Unexpected interval: " + other));
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        PointInterval oth = (PointInterval)other;
        return this.points.equals(oth.points);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        int i = 0;
        for (T point : this.points) {
            if (i > 0) {
                s.append(",");
            }
            s.append(point);
            ++i;
        }
        s.append("]");
        return s.toString();
    }
}

