/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.net.URL;
import jcifs.Config;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.support.spnego.authentication.handler.support.JcifsConfig$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public final class JcifsConfig
implements InitializingBean {
    private static final String DEFAULT_LOGIN_CONFIG = "/login.conf";
    private static final String SYS_PROP_USE_SUBJECT_CRED_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_KERBEROS_DEBUG = "sun.security.krb5.debug";
    private static final String SYS_PROP_KERBEROS_CONF = "java.security.krb5.conf";
    private static final String SYS_PROP_KERBEROS_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERBEROS_KDC = "java.security.krb5.kdc";
    private static final String JCIFS_PROP_DOMAIN_CONTROLLER = "jcifs.http.domainController";
    private static final String JCIFS_PROP_NETBIOS_WINS = "jcifs.netbios.wins";
    private static final String JCIFS_PROP_CLIENT_DOMAIN = "jcifs.smb.client.domain";
    private static final String JCIFS_PROP_CLIENT_USERNAME = "jcifs.smb.client.username";
    private static final String JCIFS_PROP_CLIENT_PASSWORD = "jcifs.smb.client.password";
    private static final String JCIFS_PROP_CLIENT_SOTIMEOUT = "jcifs.smb.client.soTimeout";
    private static final String JCIFS_PROP_NETBIOS_CACHE_POLICY = "jcifs.netbios.cachePolicy";
    private static final String JCIFS_PROP_SERVICE_PRINCIPAL = "jcifs.spnego.servicePrincipal";
    private static final String JCIFS_PROP_SERVICE_PASSWORD = "jcifs.spnego.servicePassword";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String loginConf;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public JcifsConfig() {
        Config.setProperty((String)JCIFS_PROP_CLIENT_SOTIMEOUT, (String)"300000");
        Config.setProperty((String)JCIFS_PROP_NETBIOS_CACHE_POLICY, (String)"600");
    }

    public void afterPropertiesSet() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new JcifsConfig$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Autowired
    public void setJcifsServicePassword(@Value(value="${cas.spnego.jcifs.service.password:}") String jcifsServicePassword) {
        if (StringUtils.isNotBlank((CharSequence)jcifsServicePassword)) {
            this.logger.debug("jcifsServicePassword is set to *****");
            Config.setProperty((String)JCIFS_PROP_SERVICE_PASSWORD, (String)jcifsServicePassword);
        }
    }

    @Autowired
    public void setJcifsServicePrincipal(@Value(value="${cas.spnego.service.principal:HTTP/cas.example.com@EXAMPLE.COM}") String jcifsServicePrincipal) {
        if (StringUtils.isNotBlank((CharSequence)jcifsServicePrincipal)) {
            this.logger.debug("jcifsServicePrincipal is set to {}", (Object)jcifsServicePrincipal);
            Config.setProperty((String)JCIFS_PROP_SERVICE_PRINCIPAL, (String)jcifsServicePrincipal);
        }
    }

    @Autowired
    public void setKerberosConf(@Value(value="${cas.spnego.kerb.conf:}") String kerberosConf) {
        if (StringUtils.isNotBlank((CharSequence)kerberosConf)) {
            this.logger.debug("kerberosConf is set to :{}", (Object)kerberosConf);
            System.setProperty(SYS_PROP_KERBEROS_CONF, kerberosConf);
        }
    }

    @Autowired
    public void setKerberosKdc(@Value(value="${cas.spnego.kerb.kdc:172.10.1.10}") String kerberosKdc) {
        if (StringUtils.isNotBlank((CharSequence)kerberosKdc)) {
            this.logger.debug("kerberosKdc is set to : {}", (Object)kerberosKdc);
            System.setProperty(SYS_PROP_KERBEROS_KDC, kerberosKdc);
        }
    }

    @Autowired
    public void setKerberosRealm(@Value(value="${cas.spnego.kerb.realm:EXAMPLE.COM}") String kerberosRealm) {
        if (StringUtils.isNotBlank((CharSequence)kerberosRealm)) {
            this.logger.debug("kerberosRealm is set to :{}", (Object)kerberosRealm);
            System.setProperty(SYS_PROP_KERBEROS_REALM, kerberosRealm);
        }
    }

    @Autowired
    public void setLoginConf(@Value(value="${cas.spnego.login.conf.file:/path/to/login.conf}") String loginConf) {
        this.loginConf = loginConf;
    }

    @Autowired
    public void setUseSubjectCredsOnly(@Value(value="${cas.spnego.use.subject.creds:false}") boolean useSubjectCredsOnly) {
        this.logger.debug("useSubjectCredsOnly is set to {}", (Object)useSubjectCredsOnly);
        System.setProperty(SYS_PROP_USE_SUBJECT_CRED_ONLY, Boolean.toString(useSubjectCredsOnly));
    }

    @Autowired
    public void setKerberosDebug(@Value(value="${cas.spnego.kerb.debug:false}") String kerberosDebug) {
        if (StringUtils.isNotBlank((CharSequence)kerberosDebug)) {
            this.logger.debug("kerberosDebug is set to : {}", (Object)kerberosDebug);
            System.setProperty(SYS_PROP_KERBEROS_DEBUG, kerberosDebug);
        }
    }

    @Autowired
    public void setJcifsDomain(@Value(value="${cas.spnego.jcifs.domain:}") String jcifsDomain) {
        if (StringUtils.isNotBlank((CharSequence)jcifsDomain)) {
            this.logger.debug("jcifsDomain is set to {}", (Object)jcifsDomain);
            Config.setProperty((String)JCIFS_PROP_CLIENT_DOMAIN, (String)jcifsDomain);
        }
    }

    @Autowired
    public void setJcifsDomainController(@Value(value="${cas.spnego.jcifs.domaincontroller:}") String jcifsDomainController) {
        if (StringUtils.isNotBlank((CharSequence)jcifsDomainController)) {
            this.logger.debug("jcifsDomainController is set to {}", (Object)jcifsDomainController);
            Config.setProperty((String)JCIFS_PROP_DOMAIN_CONTROLLER, (String)jcifsDomainController);
        }
    }

    @Autowired
    public void setJcifsPassword(@Value(value="${cas.spnego.jcifs.password:}") String jcifsPassword) {
        if (StringUtils.isNotBlank((CharSequence)jcifsPassword)) {
            Config.setProperty((String)JCIFS_PROP_CLIENT_PASSWORD, (String)jcifsPassword);
            this.logger.debug("jcifsPassword is set to *****");
        }
    }

    @Autowired
    public void setJcifsUsername(@Value(value="${cas.spnego.jcifs.username:}") String jcifsUsername) {
        if (StringUtils.isNotBlank((CharSequence)jcifsUsername)) {
            this.logger.debug("jcifsUsername is set to {}", (Object)jcifsUsername);
            Config.setProperty((String)JCIFS_PROP_CLIENT_USERNAME, (String)jcifsUsername);
        }
    }

    @Autowired
    public void setJcifsNetbiosWins(@Value(value="${cas.spnego.jcifs.netbios.wins:}") String jcifsNetbiosWins) {
        if (StringUtils.isNotBlank((CharSequence)jcifsNetbiosWins)) {
            this.logger.debug("jcifsNetbiosWins is set to {}", (Object)jcifsNetbiosWins);
            Config.setProperty((String)JCIFS_PROP_NETBIOS_WINS, (String)jcifsNetbiosWins);
        }
    }

    @Autowired
    public void setJcifsNetbiosCachePolicy(@Value(value="${cas.spnego.jcifs.netbios.cache.policy:600}") String policy) {
        if (StringUtils.isNotBlank((CharSequence)policy)) {
            this.logger.debug("jcifsNetbiosCachePolicy is set to {}", (Object)policy);
            Config.setProperty((String)JCIFS_PROP_NETBIOS_CACHE_POLICY, (String)policy);
        }
    }

    @Autowired
    public void setJcifsSocketTimeout(@Value(value="${cas.spnego.jcifs.socket.timeout:300000}") String timeout) {
        if (StringUtils.isNotBlank((CharSequence)timeout)) {
            this.logger.debug("jcifsSocketTimeout is set to {}", (Object)timeout);
            Config.setProperty((String)JCIFS_PROP_CLIENT_SOTIMEOUT, (String)timeout);
        }
    }

    static {
        JcifsConfig.ajc$preClinit();
    }

    static final /* synthetic */ void afterPropertiesSet_aroundBody0(JcifsConfig ajc$this, JoinPoint joinPoint) {
        URL url;
        String propValue = System.getProperty(SYS_PROP_LOGIN_CONF);
        if (propValue != null) {
            ajc$this.logger.warn("found login config in system property, may override : {}", (Object)propValue);
        }
        if ((url = ajc$this.getClass().getResource(ajc$this.loginConf == null ? DEFAULT_LOGIN_CONFIG : ajc$this.loginConf)) != null) {
            ajc$this.loginConf = url.toExternalForm();
        }
        if (ajc$this.loginConf != null) {
            System.setProperty(SYS_PROP_LOGIN_CONF, ajc$this.loginConf);
        } else {
            url = ajc$this.getClass().getResource("/jcifs/http/login.conf");
            if (url != null) {
                System.setProperty(SYS_PROP_LOGIN_CONF, url.toExternalForm());
            }
        }
        ajc$this.logger.debug("configured login configuration path : {}", (Object)propValue);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JcifsConfig.java", JcifsConfig.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.support.spnego.authentication.handler.support.JcifsConfig", "", "", "java.lang.Exception", "void"), 77);
    }
}

