/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler$AjcClosure1;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="spnegoHandler")
public final class JcifsSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Autowired
    @Qualifier(value="spnegoAuthentication")
    private Authentication authentication;
    @Value(value="${cas.spengo.use.principal.domain:false}")
    private boolean principalWithDomainName = true;
    @Value(value="${cas.spnego.ntlm.allowed:true}")
    private boolean isNTLMallowed;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        byte[] nextToken;
        Principal principal;
        SpnegoCredential spnegoCredential = (SpnegoCredential)credential;
        if (!this.isNTLMallowed && spnegoCredential.isNtlm()) {
            throw new FailedLoginException("NTLM not allowed");
        }
        try {
            JcifsSpnegoAuthenticationHandler jcifsSpnegoAuthenticationHandler = this;
            synchronized (jcifsSpnegoAuthenticationHandler) {
                this.authentication.reset();
                this.authentication.process(spnegoCredential.getInitToken());
                principal = this.authentication.getPrincipal();
                nextToken = this.authentication.getNextToken();
            }
        }
        catch (AuthenticationException e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (nextToken != null) {
            this.logger.debug("Setting nextToken in credential");
            spnegoCredential.setNextToken(nextToken);
        } else {
            this.logger.debug("nextToken is null");
        }
        boolean success = false;
        if (principal != null) {
            if (spnegoCredential.isNtlm()) {
                this.logger.debug("NTLM Credential is valid for user [{}]", (Object)principal.getName());
            } else {
                this.logger.debug("Kerberos Credential is valid for user [{}]", (Object)principal.getName());
            }
            spnegoCredential.setPrincipal(this.getPrincipal(principal.getName(), spnegoCredential.isNtlm()));
            success = true;
        }
        if (!success) {
            throw new FailedLoginException("Principal is null, the processing of the SPNEGO Token failed");
        }
        return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), spnegoCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new JcifsSpnegoAuthenticationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    public void setNTLMallowed(boolean isNTLMallowed) {
        this.isNTLMallowed = isNTLMallowed;
    }

    protected org.jasig.cas.authentication.principal.Principal getPrincipal(String name, boolean isNtlm) {
        if (this.principalWithDomainName) {
            return this.principalFactory.createPrincipal(name);
        }
        if (isNtlm) {
            return Pattern.matches("\\S+\\\\\\S+", name) ? this.principalFactory.createPrincipal(name.split("\\\\")[1]) : this.principalFactory.createPrincipal(name);
        }
        return this.principalFactory.createPrincipal(name.split("@")[0]);
    }

    static {
        JcifsSpnegoAuthenticationHandler.ajc$preClinit();
    }

    static final /* synthetic */ boolean supports_aroundBody0(JcifsSpnegoAuthenticationHandler ajc$this, Credential credential, JoinPoint joinPoint) {
        return credential instanceof SpnegoCredential;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JcifsSpnegoAuthenticationHandler.java", JcifsSpnegoAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 96);
    }
}

