/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler$AjcClosure1;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="ntlmAuthenticationHandler")
public class NtlmAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final int NBT_ADDRESS_TYPE = 28;
    private static final int NTLM_TOKEN_TYPE_FIELD_INDEX = 8;
    private static final int NTLM_TOKEN_TYPE_ONE = 1;
    private static final int NTLM_TOKEN_TYPE_THREE = 3;
    private static final String DEFAULT_DOMAIN_CONTROLLER;
    private boolean loadBalance = true;
    private String domainController = DEFAULT_DOMAIN_CONTROLLER;
    private String includePattern;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        NtlmAuthenticationHandler.ajc$preClinit();
        DEFAULT_DOMAIN_CONTROLLER = Config.getProperty((String)"jcifs.smb.client.domain");
    }

    protected final HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        SpnegoCredential ntlmCredential = (SpnegoCredential)credential;
        byte[] src = ntlmCredential.getInitToken();
        UniAddress dc = null;
        boolean success = false;
        try {
            if (this.loadBalance) {
                if (StringUtils.isNotBlank((CharSequence)this.includePattern)) {
                    NbtAddress[] dcs;
                    NbtAddress[] nbtAddressArray = dcs = NbtAddress.getAllByName((String)this.domainController, (int)28, null, null);
                    int n = dcs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NbtAddress dc2 = nbtAddressArray[n2];
                        if (dc2.getHostAddress().matches(this.includePattern)) {
                            dc = new UniAddress((Object)dc2);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    dc = new UniAddress((Object)NbtAddress.getByName((String)this.domainController, (int)28, null));
                }
            } else {
                dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            }
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            switch (src[8]) {
                case 1: {
                    this.logger.debug("Type 1 received");
                    Type1Message type1 = new Type1Message(src);
                    Type2Message type2 = new Type2Message(type1, challenge, null);
                    this.logger.debug("Type 2 returned. Setting next token.");
                    ntlmCredential.setNextToken(type2.toByteArray());
                    break;
                }
                case 3: {
                    this.logger.debug("Type 3 received");
                    Type3Message type3 = new Type3Message(src);
                    byte[] lmResponse = type3.getLMResponse() == null ? new byte[]{} : type3.getLMResponse();
                    byte[] ntResponse = type3.getNTResponse() == null ? new byte[]{} : type3.getNTResponse();
                    NtlmPasswordAuthentication ntlm = new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
                    this.logger.debug("Trying to authenticate {} with domain controller", (Object)type3.getUser());
                    try {
                        SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                        ntlmCredential.setPrincipal(this.principalFactory.createPrincipal(type3.getUser()));
                        success = true;
                        break;
                    }
                    catch (SmbAuthException sae) {
                        throw new FailedLoginException(sae.getMessage());
                    }
                }
                default: {
                    this.logger.debug("Unknown type: {}", (Object)src[8]);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (!success) {
            throw new FailedLoginException();
        }
        return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)ntlmCredential), ntlmCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        Credential credential2 = credential;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)credential2);
        Object[] objectArray = new Object[]{this, credential2, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new NtlmAuthenticationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @Autowired
    public void setLoadBalance(@Value(value="${ntlm.authn.load.balance:true}") boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    @Autowired
    public void setDomainController(@Value(value="${ntlm.authn.domain.controller:}") @NotNull String domainController) {
        this.domainController = StringUtils.isBlank((CharSequence)domainController) ? DEFAULT_DOMAIN_CONTROLLER : domainController;
    }

    @Autowired
    public void setIncludePattern(@Value(value="${ntlm.authn.include.pattern:}") String includePattern) {
        this.includePattern = includePattern;
    }

    static final /* synthetic */ boolean supports_aroundBody0(NtlmAuthenticationHandler ajc$this, Credential credential, JoinPoint joinPoint) {
        return credential instanceof SpnegoCredential;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NtlmAuthenticationHandler.java", NtlmAuthenticationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supports", "org.jasig.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler", "org.jasig.cas.authentication.Credential", "credential", "", "boolean"), 121);
    }
}

