/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

@Component
public final class SpnegoCredentialsAction
extends AbstractNonInteractiveCredentialsAction {
    @Value(value="${cas.spnego.ntlm.allowed:true}")
    private boolean ntlm;
    private String messageBeginPrefix = this.constructMessagePrefix();
    @Value(value="${cas.spnego.send.401.authn.failure:false}")
    private boolean send401OnAuthenticationFailure = true;

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        if (StringUtils.hasText((String)authorizationHeader) && authorizationHeader.startsWith(this.messageBeginPrefix) && authorizationHeader.length() > this.messageBeginPrefix.length()) {
            this.logger.debug("SPNEGO Authorization header found with {} bytes", (Object)(authorizationHeader.length() - this.messageBeginPrefix.length()));
            byte[] token = CompressionUtils.decodeBase64ToByteArray((String)authorizationHeader.substring(this.messageBeginPrefix.length()));
            if (token == null) {
                this.logger.warn("Could not compress authorization header in base64");
                return null;
            }
            this.logger.debug("Obtained token: {}", (Object)new String(token, Charset.defaultCharset()));
            return new SpnegoCredential(token);
        }
        return null;
    }

    protected String constructMessagePrefix() {
        return String.valueOf(this.ntlm ? "NTLM" : "Negotiate") + ' ';
    }

    protected void onError(RequestContext context, Credential credential) {
        this.setResponseHeader(context, credential);
    }

    protected void onSuccess(RequestContext context, Credential credential) {
        this.setResponseHeader(context, credential);
    }

    private void setResponseHeader(RequestContext context, Credential credential) {
        if (credential == null) {
            return;
        }
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        SpnegoCredential spnegoCredentials = (SpnegoCredential)credential;
        byte[] nextToken = spnegoCredentials.getNextToken();
        if (nextToken != null) {
            this.logger.debug("Obtained output token: {}", (Object)new String(nextToken, Charset.defaultCharset()));
            response.setHeader("WWW-Authenticate", String.valueOf(this.ntlm ? "NTLM" : "Negotiate") + ' ' + CompressionUtils.encodeBase64((byte[])nextToken));
        } else {
            this.logger.debug("Unable to obtain the output token required.");
        }
        if (spnegoCredentials.getPrincipal() == null && this.send401OnAuthenticationFailure) {
            this.logger.debug("Setting HTTP Status to 401");
            response.setStatus(401);
        }
    }

    public void setNtlm(boolean ntlm) {
        this.ntlm = ntlm;
        this.messageBeginPrefix = this.constructMessagePrefix();
    }

    public void setSend401OnAuthenticationFailure(boolean send401OnAuthenticationFailure) {
        this.send401OnAuthenticationFailure = send401OnAuthenticationFailure;
    }
}

