/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="negociateSpnego")
public final class SpnegoNegociateCredentialsAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoNegociateCredentialsAction.class);
    @Value(value="${cas.spnego.ntlm:false}")
    private boolean ntlm;
    @Value(value="${cas.spnego.mixed.mode.authn:false}")
    private boolean mixedModeAuthentication;
    @Value(value="#{T(java.util.Arrays).asList('${cas.spnego.supportedBrowsers:MSIE,Trident,Firefox,AppleWebKit}')}")
    private List<String> supportedBrowser;
    private String messageBeginPrefix = this.constructMessagePrefix();

    public SpnegoNegociateCredentialsAction() {
        this.supportedBrowser = new ArrayList<String>();
        this.supportedBrowser.add("MSIE");
        this.supportedBrowser.add("Trident");
        this.supportedBrowser.add("Firefox");
        this.supportedBrowser.add("AppleWebKit");
    }

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        String userAgent = request.getHeader("User-Agent");
        LOGGER.debug("Authorization header [{}], User Agent header [{}]", (Object)authorizationHeader, (Object)userAgent);
        if (!StringUtils.hasText((String)userAgent) || this.supportedBrowser.isEmpty()) {
            LOGGER.debug("User Agent header [{}] is empty, or no browsers are supported", (Object)userAgent);
            return this.success();
        }
        if (!this.isSupportedBrowser(userAgent)) {
            LOGGER.debug("User Agent header [{}] is not supported in the list of supported browsers [{}]", (Object)userAgent, this.supportedBrowser);
            return this.success();
        }
        if (!StringUtils.hasText((String)authorizationHeader) || !authorizationHeader.startsWith(this.messageBeginPrefix) || authorizationHeader.length() <= this.messageBeginPrefix.length()) {
            String wwwHeader = this.ntlm ? "NTLM" : "Negotiate";
            LOGGER.debug("Authorization header not found or does not match the message prefix [{}]. Sending [{}] header [{}]", new Object[]{this.messageBeginPrefix, "WWW-Authenticate", wwwHeader});
            response.setHeader("WWW-Authenticate", wwwHeader);
            response.setStatus(401);
            if (!this.mixedModeAuthentication) {
                LOGGER.debug("Mixed-mode authentication is disabled. Executing completion of response");
                context.getExternalContext().recordResponseComplete();
            }
        }
        return this.success();
    }

    public void setNtlm(boolean ntlm) {
        this.ntlm = ntlm;
        this.messageBeginPrefix = this.constructMessagePrefix();
    }

    public void setSupportedBrowser(List<String> supportedBrowser) {
        this.supportedBrowser = supportedBrowser;
    }

    public void setMixedModeAuthentication(boolean enabled) {
        this.mixedModeAuthentication = enabled;
    }

    protected String constructMessagePrefix() {
        return String.valueOf(this.ntlm ? "NTLM" : "Negotiate") + ' ';
    }

    protected boolean isSupportedBrowser(String userAgent) {
        for (String supportedBrowser : this.supportedBrowser) {
            if (!userAgent.contains(supportedBrowser)) continue;
            return true;
        }
        return false;
    }
}

