/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.support.spnego.util.ReverseDNSRunnable;
import org.jasig.cas.support.spnego.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction$AjcClosure1;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="baseSpnegoClientAction")
public class BaseSpnegoKnownClientSystemsFilterAction
extends AbstractAction {
    private static final int DEFAULT_TIMEOUT = 2000;
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${cas.spnego.ip.pattern:127.+}")
    private Pattern ipsToCheckPattern;
    @Value(value="${cas.spnego.alt.remote.host.attribute:alternateRemoteHeader}")
    private String alternativeRemoteHostAttribute;
    private long timeout = 2000L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public BaseSpnegoKnownClientSystemsFilterAction() {
    }

    public BaseSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern) {
        this.setIpsToCheckPattern(ipsToCheckPattern);
    }

    public BaseSpnegoKnownClientSystemsFilterAction(String ipsToCheckPattern, String alternativeRemoteHostAttribute) {
        this.setIpsToCheckPattern(ipsToCheckPattern);
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    public BaseSpnegoKnownClientSystemsFilterAction(Pattern ipsToCheckPattern, String alternativeRemoteHostAttribute) {
        this.ipsToCheckPattern = ipsToCheckPattern;
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    protected final Event doExecute(RequestContext context) {
        String remoteIp = this.getRemoteIp(context);
        this.logger.debug("Current user IP {}", (Object)remoteIp);
        return this.shouldDoSpnego(remoteIp) ? this.yes() : this.no();
    }

    protected boolean shouldDoSpnego(String remoteIp) {
        return this.ipPatternCanBeChecked(remoteIp) && this.ipPatternMatches(remoteIp);
    }

    protected boolean ipPatternCanBeChecked(String remoteIp) {
        return this.ipsToCheckPattern != null && StringUtils.isNotBlank((CharSequence)remoteIp);
    }

    protected boolean ipPatternMatches(String remoteIp) {
        Matcher matcher = this.ipsToCheckPattern.matcher(remoteIp);
        if (matcher.find()) {
            this.logger.debug("Remote IP address {} should be checked based on the defined pattern {}", (Object)remoteIp, (Object)this.ipsToCheckPattern.pattern());
            return true;
        }
        this.logger.debug("No pattern or remote IP defined, or pattern does not match remote IP [{}]", (Object)remoteIp);
        return false;
    }

    private String getRemoteIp(@NotNull RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String userAddress = request.getRemoteAddr();
        this.logger.debug("Remote Address = {}", (Object)userAddress);
        if (StringUtils.isNotBlank((CharSequence)this.alternativeRemoteHostAttribute)) {
            userAddress = request.getHeader(this.alternativeRemoteHostAttribute);
            this.logger.debug("Header Attribute [{}] = [{}]", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            if (StringUtils.isBlank((CharSequence)userAddress)) {
                userAddress = request.getRemoteAddr();
                this.logger.warn("No value could be retrieved from the header [{}]. Falling back to [{}].", (Object)this.alternativeRemoteHostAttribute, (Object)userAddress);
            }
        }
        return userAddress;
    }

    public final void setAlternativeRemoteHostAttribute(@NotNull String alternativeRemoteHostAttribute) {
        this.alternativeRemoteHostAttribute = alternativeRemoteHostAttribute;
    }

    public final void setIpsToCheckPattern(@NotNull String ipsToCheckPattern) {
        this.ipsToCheckPattern = Pattern.compile(ipsToCheckPattern);
    }

    public final String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new BaseSpnegoKnownClientSystemsFilterAction$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected String getRemoteHostName(String remoteIp) {
        ReverseDNSRunnable revDNS = new ReverseDNSRunnable(remoteIp);
        Thread t = new Thread(revDNS);
        t.start();
        try {
            t.join(this.timeout);
        }
        catch (InterruptedException e) {
            this.logger.debug("Threaded lookup failed.  Defaulting to IP {}.", (Object)remoteIp, (Object)e);
        }
        String remoteHostName = revDNS.get();
        this.logger.debug("Found remote host name {}.", (Object)remoteHostName);
        return StringUtils.isNotEmpty((CharSequence)remoteHostName) ? remoteHostName : remoteIp;
    }

    static {
        BaseSpnegoKnownClientSystemsFilterAction.ajc$preClinit();
    }

    static final /* synthetic */ String toString_aroundBody0(BaseSpnegoKnownClientSystemsFilterAction ajc$this, JoinPoint joinPoint) {
        return new ToStringBuilder((Object)ajc$this).append("ipsToCheckPattern", (Object)ajc$this.ipsToCheckPattern).append("alternativeRemoteHostAttribute", (Object)ajc$this.alternativeRemoteHostAttribute).append("timeout", ajc$this.timeout).toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseSpnegoKnownClientSystemsFilterAction.java", BaseSpnegoKnownClientSystemsFilterAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "toString", "org.jasig.cas.support.spnego.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction", "", "", "", "java.lang.String"), 184);
    }
}

