/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow.client;

import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.jasig.cas.support.spnego.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="hostnameSpnegoClientAction")
public class HostNameSpnegoKnownClientSystemsFilterAction
extends BaseSpnegoKnownClientSystemsFilterAction {
    private Pattern hostNamePatternString;

    public HostNameSpnegoKnownClientSystemsFilterAction() {
    }

    @Autowired
    public HostNameSpnegoKnownClientSystemsFilterAction(@NotNull @Value(value="${cas.spnego.hostname.pattern:something.+}") String hostNamePatternString) {
        this.hostNamePatternString = Pattern.compile(hostNamePatternString);
    }

    @Override
    protected boolean shouldDoSpnego(String remoteIp) {
        boolean ipCheck = this.ipPatternCanBeChecked(remoteIp);
        if (ipCheck && !this.ipPatternMatches(remoteIp)) {
            return false;
        }
        String hostName = this.getRemoteHostName(remoteIp);
        this.logger.debug("Retrieved host name for the remote ip is {}", (Object)hostName);
        return this.hostNamePatternString.matcher(hostName).find();
    }
}

