/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow.client;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.support.spnego.web.flow.client.BaseSpnegoKnownClientSystemsFilterAction;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="ldapSpnegoClientAction")
public class LdapSpnegoKnownClientSystemsFilterAction
extends BaseSpnegoKnownClientSystemsFilterAction {
    public static final String DEFAULT_SPNEGO_ATTRIBUTE = "distinguishedName";
    @Value(value="${cas.spnego.ldap.attribute:spnegoAttribute}")
    protected String spnegoAttributeName;
    @Autowired(required=false)
    @Qualifier(value="spnegoClientActionConnectionFactory")
    protected ConnectionFactory connectionFactory;
    @Autowired(required=false)
    @Qualifier(value="spnegoClientActionSearchRequest")
    protected SearchRequest searchRequest;

    private LdapSpnegoKnownClientSystemsFilterAction() {
    }

    public LdapSpnegoKnownClientSystemsFilterAction(@NotNull ConnectionFactory connectionFactory, @NotNull SearchRequest searchRequest) {
        this(connectionFactory, searchRequest, DEFAULT_SPNEGO_ATTRIBUTE);
    }

    public LdapSpnegoKnownClientSystemsFilterAction(@NotNull ConnectionFactory connectionFactory, @NotNull SearchRequest searchRequest, @NotNull String spnegoAttributeName) {
        this.connectionFactory = connectionFactory;
        this.spnegoAttributeName = spnegoAttributeName;
        this.searchRequest = searchRequest;
    }

    protected Connection createConnection() throws LdapException {
        this.logger.debug("Establishing a connection...");
        Connection connection = this.connectionFactory.getConnection();
        connection.open();
        return connection;
    }

    @Override
    protected boolean shouldDoSpnego(String remoteIp) {
        if (StringUtils.isBlank((CharSequence)this.spnegoAttributeName)) {
            this.logger.warn("Ignoring Spnego. Attribute name is not configured");
            return false;
        }
        if (this.connectionFactory == null) {
            this.logger.warn("Ignoring Spnego. LDAP connection factory is not configured");
            return false;
        }
        if (this.searchRequest == null) {
            this.logger.warn("Ignoring Spnego. LDAP search request is not configured");
            return false;
        }
        boolean ipCheck = this.ipPatternCanBeChecked(remoteIp);
        if (ipCheck && !this.ipPatternMatches(remoteIp)) {
            return false;
        }
        return this.executeSearchForSpnegoAttribute(remoteIp);
    }

    protected boolean executeSearchForSpnegoAttribute(String remoteIp) {
        Connection connection = null;
        String remoteHostName = this.getRemoteHostName(remoteIp);
        this.logger.debug("Resolved remote hostname {} based on ip {}", (Object)remoteHostName, (Object)remoteIp);
        try {
            connection = this.createConnection();
            SearchOperation searchOperation = new SearchOperation(connection);
            this.searchRequest.getSearchFilter().setParameter(0, (Object)remoteHostName);
            this.logger.debug("Using search filter {} on baseDn {}", (Object)this.searchRequest.getSearchFilter().format(), (Object)this.searchRequest.getBaseDn());
            Response searchResult = searchOperation.execute((Request)this.searchRequest);
            if (searchResult.getResultCode() == ResultCode.SUCCESS) {
                boolean bl = this.processSpnegoAttribute((Response<SearchResult>)searchResult);
                return bl;
            }
            try {
                throw new RuntimeException("Failed to establish a connection ldap. " + searchResult.getMessage());
            }
            catch (LdapException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected boolean processSpnegoAttribute(Response<SearchResult> searchResult) {
        SearchResult result = (SearchResult)searchResult.getResult();
        if (result == null || result.getEntries().isEmpty()) {
            this.logger.debug("Spnego attribute is not found in the search results");
            return false;
        }
        LdapEntry entry = result.getEntry();
        LdapAttribute attribute = entry.getAttribute(this.spnegoAttributeName);
        return this.verifySpnegyAttributeValue(attribute);
    }

    protected boolean verifySpnegyAttributeValue(LdapAttribute attribute) {
        return attribute != null && StringUtils.isNotBlank((CharSequence)attribute.getStringValue());
    }
}

