/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static byte[] readResourceBytes(String resourceName) {
        try {
            return Util.bytes(Util.class.getResourceAsStream(resourceName));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String readResource(String resourceName) {
        try {
            return Util.read(Util.class.getResourceAsStream(resourceName));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String readFile(String fileName) {
        try {
            FileInputStream fin = new FileInputStream(fileName);
            return Util.read(fin);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String read(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        int x = in.read();
        while (x != -1) {
            sb.append((char)x);
            x = in.read();
        }
        return sb.toString();
    }

    public static byte[] bytes(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[128];
        int x = in.read(bytes);
        while (x != -1) {
            bout.write(bytes, 0, x);
            x = in.read(bytes);
        }
        return bout.toByteArray();
    }

    public static byte[] read(File file) throws IOException {
        return Util.bytes(new FileInputStream(file));
    }

    public static List<String> getResourceLines(String resourceName) throws IOException {
        String tmp;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(Util.class.getResourceAsStream(resourceName)));
        while ((tmp = reader.readLine()) != null) {
            lines.add(tmp);
        }
        return lines;
    }

    public static boolean blank(Object value) {
        return value == null || value.toString().trim().equals("");
    }

    public static String join(String[] collection, String delimiter) {
        return Util.join(Arrays.asList(collection), delimiter);
    }

    public static String[] split(String input, char delimiter) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input, new String(new byte[]{(byte)delimiter}));
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String join(Collection collection, String delimiter) {
        if (collection.size() == 0) {
            return "";
        }
        String tmp = "";
        for (Object o : collection) {
            tmp = tmp + o + delimiter;
        }
        return tmp.substring(0, tmp.length() - delimiter.length());
    }

    public static void saveTo(String path, InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        byte[] bytes = new byte[128];
        FileOutputStream fout = new FileOutputStream(path);
        int x = in.read(bytes);
        while (x != -1) {
            fout.write(bytes, 0, x);
            x = in.read(bytes);
        }
        fout.flush();
        fout.close();
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(throwable.toString());
        throwable.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

