/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keywords {
    public static final String META = "Meta";
    public static final String META_PROPERTY = "MetaProperty";
    public static final String NARRATIVE = "Narrative";
    public static final String IN_ORDER_TO = "InOrderTo";
    public static final String AS_A = "AsA";
    public static final String I_WANT_TO = "IWantTo";
    public static final String SCENARIO = "Scenario";
    public static final String GIVEN_STORIES = "GivenStories";
    public static final String EXAMPLES_TABLE = "ExamplesTable";
    public static final String EXAMPLES_TABLE_ROW = "ExamplesTableRow";
    public static final String EXAMPLES_TABLE_HEADER_SEPARATOR = "ExamplesTableHeaderSeparator";
    public static final String EXAMPLES_TABLE_VALUE_SEPARATOR = "ExamplesTableValueSeparator";
    public static final String EXAMPLES_TABLE_IGNORABLE_SEPARATOR = "ExamplesTableIgnorableSeparator";
    public static final String GIVEN = "Given";
    public static final String WHEN = "When";
    public static final String THEN = "Then";
    public static final String AND = "And";
    public static final String IGNORABLE = "Ignorable";
    public static final String PENDING = "Pending";
    public static final String NOT_PERFORMED = "NotPerformed";
    public static final String FAILED = "Failed";
    public static final String DRY_RUN = "DryRun";
    public static final List<String> KEYWORDS = Arrays.asList("Meta", "MetaProperty", "Narrative", "InOrderTo", "AsA", "IWantTo", "Scenario", "GivenStories", "ExamplesTable", "ExamplesTableRow", "ExamplesTableHeaderSeparator", "ExamplesTableValueSeparator", "ExamplesTableIgnorableSeparator", "Given", "When", "Then", "And", "Ignorable", "Pending", "NotPerformed", "Failed", "DryRun");
    private final String meta;
    private final String metaProperty;
    private final String narrative;
    private final String inOrderTo;
    private final String asA;
    private final String iWantTo;
    private final String scenario;
    private final String givenStories;
    private final String examplesTable;
    private final String examplesTableRow;
    private final String examplesTableHeaderSeparator;
    private final String examplesTableValueSeparator;
    private final String examplesTableIgnorableSeparator;
    private final String given;
    private final String when;
    private final String then;
    private final String and;
    private final String ignorable;
    private final String pending;
    private final String notPerformed;
    private final String failed;
    private final String dryRun;
    private final Map<StepType, String> startingWordsByType = new HashMap<StepType, String>();

    public static Map<String, String> defaultKeywords() {
        HashMap<String, String> keywords = new HashMap<String, String>();
        keywords.put(META, "Meta:");
        keywords.put(META_PROPERTY, "@");
        keywords.put(NARRATIVE, "Narrative:");
        keywords.put(IN_ORDER_TO, "In order to:");
        keywords.put(AS_A, "As a:");
        keywords.put(I_WANT_TO, "I want to:");
        keywords.put(SCENARIO, "Scenario:");
        keywords.put(GIVEN_STORIES, "GivenStories:");
        keywords.put(EXAMPLES_TABLE, "Examples:");
        keywords.put(EXAMPLES_TABLE_ROW, "Example:");
        keywords.put(EXAMPLES_TABLE_HEADER_SEPARATOR, "|");
        keywords.put(EXAMPLES_TABLE_VALUE_SEPARATOR, "|");
        keywords.put(EXAMPLES_TABLE_IGNORABLE_SEPARATOR, "|--");
        keywords.put(GIVEN, GIVEN);
        keywords.put(WHEN, WHEN);
        keywords.put(THEN, THEN);
        keywords.put(AND, AND);
        keywords.put(IGNORABLE, "!--");
        keywords.put(PENDING, "PENDING");
        keywords.put(NOT_PERFORMED, "NOT PERFORMED");
        keywords.put(FAILED, "FAILED");
        keywords.put(DRY_RUN, "DRY RUN");
        return keywords;
    }

    public Keywords() {
        this(Keywords.defaultKeywords());
    }

    public Keywords(Map<String, String> keywords) {
        this.meta = this.keyword(META, keywords);
        this.metaProperty = this.keyword(META_PROPERTY, keywords);
        this.narrative = this.keyword(NARRATIVE, keywords);
        this.inOrderTo = this.keyword(IN_ORDER_TO, keywords);
        this.asA = this.keyword(AS_A, keywords);
        this.iWantTo = this.keyword(I_WANT_TO, keywords);
        this.scenario = this.keyword(SCENARIO, keywords);
        this.givenStories = this.keyword(GIVEN_STORIES, keywords);
        this.examplesTable = this.keyword(EXAMPLES_TABLE, keywords);
        this.examplesTableRow = this.keyword(EXAMPLES_TABLE_ROW, keywords);
        this.examplesTableHeaderSeparator = this.keyword(EXAMPLES_TABLE_HEADER_SEPARATOR, keywords);
        this.examplesTableValueSeparator = this.keyword(EXAMPLES_TABLE_VALUE_SEPARATOR, keywords);
        this.examplesTableIgnorableSeparator = this.keyword(EXAMPLES_TABLE_IGNORABLE_SEPARATOR, keywords);
        this.given = this.keyword(GIVEN, keywords);
        this.when = this.keyword(WHEN, keywords);
        this.then = this.keyword(THEN, keywords);
        this.and = this.keyword(AND, keywords);
        this.ignorable = this.keyword(IGNORABLE, keywords);
        this.pending = this.keyword(PENDING, keywords);
        this.notPerformed = this.keyword(NOT_PERFORMED, keywords);
        this.failed = this.keyword(FAILED, keywords);
        this.dryRun = this.keyword(DRY_RUN, keywords);
        this.startingWordsByType.put(StepType.GIVEN, this.given());
        this.startingWordsByType.put(StepType.WHEN, this.when());
        this.startingWordsByType.put(StepType.THEN, this.then());
        this.startingWordsByType.put(StepType.AND, this.and());
        this.startingWordsByType.put(StepType.IGNORABLE, this.ignorable());
    }

    private String keyword(String name, Map<String, String> keywords) {
        String keyword = keywords.get(name);
        if (keyword == null) {
            throw new KeywordNotFound(name, keywords);
        }
        return keyword;
    }

    public String meta() {
        return this.meta;
    }

    public String metaProperty() {
        return this.metaProperty;
    }

    public String narrative() {
        return this.narrative;
    }

    public String inOrderTo() {
        return this.inOrderTo;
    }

    public String asA() {
        return this.asA;
    }

    public String iWantTo() {
        return this.iWantTo;
    }

    public String scenario() {
        return this.scenario;
    }

    public String givenStories() {
        return this.givenStories;
    }

    public String examplesTable() {
        return this.examplesTable;
    }

    public String examplesTableRow() {
        return this.examplesTableRow;
    }

    public String examplesTableHeaderSeparator() {
        return this.examplesTableHeaderSeparator;
    }

    public String examplesTableValueSeparator() {
        return this.examplesTableValueSeparator;
    }

    public String examplesTableIgnorableSeparator() {
        return this.examplesTableIgnorableSeparator;
    }

    public String given() {
        return this.given;
    }

    public String when() {
        return this.when;
    }

    public String then() {
        return this.then;
    }

    public String and() {
        return this.and;
    }

    public String ignorable() {
        return this.ignorable;
    }

    public String pending() {
        return this.pending;
    }

    public String notPerformed() {
        return this.notPerformed;
    }

    public String failed() {
        return this.failed;
    }

    public String dryRun() {
        return this.dryRun;
    }

    public String[] startingWords() {
        Collection<String> words = this.startingWordsByType().values();
        return words.toArray(new String[words.size()]);
    }

    public Map<StepType, String> startingWordsByType() {
        return this.startingWordsByType;
    }

    public boolean isAndStep(String stepAsString) {
        String andWord = this.startingWordFor(StepType.AND);
        return this.stepStartsWithWord(stepAsString, andWord);
    }

    public boolean isIgnorableStep(String stepAsString) {
        String ignorableWord = this.startingWordFor(StepType.IGNORABLE);
        return this.stepStartsWithWord(stepAsString, ignorableWord);
    }

    public String stepWithoutStartingWord(String stepAsString, StepType stepType) {
        String startingWord = this.startingWord(stepAsString, stepType);
        return stepAsString.substring(startingWord.length() + 1);
    }

    public String startingWord(String stepAsString, StepType stepType) throws StartingWordNotFound {
        String wordForType = this.startingWordFor(stepType);
        if (this.stepStartsWithWord(stepAsString, wordForType)) {
            return wordForType;
        }
        String andWord = this.startingWordFor(StepType.AND);
        if (this.stepStartsWithWord(stepAsString, andWord)) {
            return andWord;
        }
        throw new StartingWordNotFound(stepAsString, stepType, this.startingWordsByType);
    }

    public String startingWord(String stepAsString) throws StartingWordNotFound {
        for (StepType stepType : this.startingWordsByType.keySet()) {
            String wordForType = this.startingWordFor(stepType);
            if (!this.stepStartsWithWord(stepAsString, wordForType)) continue;
            return wordForType;
        }
        String andWord = this.startingWordFor(StepType.AND);
        if (this.stepStartsWithWord(stepAsString, andWord)) {
            return andWord;
        }
        throw new StartingWordNotFound(stepAsString, this.startingWordsByType);
    }

    public StepType stepTypeFor(String stepAsString) throws StartingWordNotFound {
        for (StepType stepType : this.startingWordsByType.keySet()) {
            String wordForType = this.startingWordFor(stepType);
            if (!this.stepStartsWithWord(stepAsString, wordForType)) continue;
            return stepType;
        }
        throw new StartingWordNotFound(stepAsString, this.startingWordsByType);
    }

    public boolean stepStartsWithWord(String step, String word) {
        return step.startsWith(word + " ");
    }

    public String startingWordFor(StepType stepType) {
        String startingWord = this.startingWordsByType.get((Object)stepType);
        if (startingWord == null) {
            throw new StartingWordNotFound(stepType, this.startingWordsByType);
        }
        return startingWord;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartingWordNotFound
    extends RuntimeException {
        public StartingWordNotFound(String step, StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found for step '" + step + "' of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }

        public StartingWordNotFound(StepType stepType, Map<StepType, String> startingWordsByType) {
            super("No starting word found of type '" + (Object)((Object)stepType) + "' amongst '" + startingWordsByType + "'");
        }

        public StartingWordNotFound(String stepAsString, Map<StepType, String> startingWordsByType) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeywordNotFound
    extends RuntimeException {
        public KeywordNotFound(String name, Map<String, String> keywords) {
            super("Keyword " + name + " not found amongst " + keywords);
        }
    }
}

