/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.reporters.SilentSuccessFilter;
import org.jbehave.core.reporters.StoryReporter;

public class PropertyBasedConfiguration
extends MostUsefulConfiguration {
    public static final String FAIL_ON_PENDING = "org.jbehave.core.configuration.failonpending";
    public static final String SILENT_SUCCESS = "org.jbehave.core.configuration.silentsuccess";

    public StoryReporter defaultStoryReporter() {
        StoryReporter storyReporter = super.defaultStoryReporter();
        if (System.getProperty(SILENT_SUCCESS) == null) {
            return storyReporter;
        }
        return new SilentSuccessFilter(storyReporter);
    }

    public PendingStepStrategy pendingStepStrategy() {
        if (System.getProperty(FAIL_ON_PENDING) == null) {
            return super.pendingStepStrategy();
        }
        return new FailingUponPendingStep();
    }
}

