/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.PrintStreamEmbedderMonitor;
import org.jbehave.core.embedder.StoryMapper;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.jbehave.core.junit.AnnotatedEmbedderUtils;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ProvidedStepsFactory;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.Stepdoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedder {
    private Configuration configuration = new MostUsefulConfiguration();
    private List<CandidateSteps> candidateSteps = new ArrayList<CandidateSteps>();
    private InjectableStepsFactory stepsFactory;
    private EmbedderClassLoader classLoader = new EmbedderClassLoader(this.getClass().getClassLoader());
    private EmbedderControls embedderControls = new EmbedderControls();
    private List<String> metaFilters = Arrays.asList(new Object[0]);
    private Properties systemProperties = new Properties();
    private StoryMapper storyMapper;
    private StoryRunner storyRunner;
    private EmbedderMonitor embedderMonitor;
    private ExecutorService executorService;

    public Embedder() {
        this(new StoryMapper(), new StoryRunner(), new PrintStreamEmbedderMonitor());
    }

    public Embedder(StoryMapper storyMapper, StoryRunner storyRunner, EmbedderMonitor embedderMonitor) {
        this.storyMapper = storyMapper;
        this.storyRunner = storyRunner;
        this.embedderMonitor = embedderMonitor;
    }

    public void mapStoriesAsPaths(List<String> storyPaths) {
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesSkipped(storyPaths);
            return;
        }
        this.processSystemProperties();
        for (String storyPath : storyPaths) {
            Story story = this.storyRunner.storyOfPath(this.configuration, storyPath);
            this.embedderMonitor.mappingStory(storyPath, this.metaFilters);
            this.storyMapper.map(story, new MetaFilter(""));
            for (String filter : this.metaFilters) {
                this.storyMapper.map(story, new MetaFilter(filter));
            }
        }
        this.generateMapsView(this.storyMapper.getStoryMaps());
    }

    private void generateMapsView(StoryMaps storyMaps) {
        Configuration configuration = this.configuration();
        StoryReporterBuilder builder = configuration.storyReporterBuilder();
        File outputDirectory = builder.outputDirectory();
        Properties viewResources = builder.viewResources();
        ViewGenerator viewGenerator = configuration.viewGenerator();
        try {
            this.embedderMonitor.generatingMapsView(outputDirectory, storyMaps, viewResources);
            viewGenerator.generateMapsView(outputDirectory, storyMaps, viewResources);
        }
        catch (RuntimeException e) {
            this.embedderMonitor.mapsViewGenerationFailed(outputDirectory, storyMaps, viewResources, e);
            throw new ViewGenerationFailed(outputDirectory, storyMaps, viewResources, e);
        }
    }

    public void runAsEmbeddables(List<String> classNames) {
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.embeddablesSkipped(classNames);
            return;
        }
        BatchFailures batchFailures = new BatchFailures();
        for (Embeddable embeddable : this.embeddables(classNames, this.classLoader())) {
            String name = embeddable.getClass().getName();
            try {
                this.embedderMonitor.runningEmbeddable(name);
                embeddable.useEmbedder(this);
                embeddable.run();
            }
            catch (Throwable e) {
                if (embedderControls.batch()) {
                    batchFailures.put(name, e);
                    continue;
                }
                if (this.ignoreFailure(embedderControls)) {
                    this.embedderMonitor.embeddableFailed(name, e);
                    continue;
                }
                throw new RunningEmbeddablesFailed(name, e);
            }
        }
        if (embedderControls.batch() && batchFailures.size() > 0) {
            if (this.ignoreFailure(embedderControls)) {
                this.embedderMonitor.batchFailed(batchFailures);
            } else {
                throw new RunningEmbeddablesFailed(batchFailures);
            }
        }
    }

    private boolean ignoreFailure(EmbedderControls embedderControls) {
        boolean ignore = embedderControls.ignoreFailureInStories();
        if (embedderControls.generateViewAfterStories()) {
            ignore = ignore && embedderControls.ignoreFailureInView();
        }
        return ignore;
    }

    private List<Embeddable> embeddables(List<String> classNames, EmbedderClassLoader classLoader) {
        ArrayList<Embeddable> embeddables = new ArrayList<Embeddable>();
        for (String className : classNames) {
            if (classLoader.isAbstract(className)) continue;
            embeddables.add(classLoader.newInstance(Embeddable.class, className));
        }
        return embeddables;
    }

    public void runStoriesWithAnnotatedEmbedderRunner(List<String> classNames) {
        EmbedderClassLoader classLoader = this.classLoader();
        for (String className : classNames) {
            this.embedderMonitor.runningWithAnnotatedEmbedderRunner(className);
            AnnotatedEmbedderRunner runner = AnnotatedEmbedderUtils.annotatedEmbedderRunner(className, classLoader);
            try {
                Object annotatedInstance = runner.createTest();
                if (annotatedInstance instanceof Embeddable) {
                    ((Embeddable)annotatedInstance).run();
                    continue;
                }
                this.embedderMonitor.annotatedInstanceNotOfType(annotatedInstance, Embeddable.class);
            }
            catch (Throwable e) {
                throw new AnnotatedEmbedderRunFailed(runner, e);
            }
        }
    }

    public void runStoriesAsPaths(List<String> storyPaths) {
        this.processSystemProperties();
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesSkipped(storyPaths);
            return;
        }
        Configuration configuration = this.configuration();
        InjectableStepsFactory stepsFactory = this.stepsFactory();
        List<CandidateSteps> candidateSteps = stepsFactory.createCandidateSteps();
        this.configureReporterBuilder(configuration);
        MetaFilter filter = new MetaFilter(StringUtils.join(this.metaFilters, (String)" "), this.embedderMonitor);
        BatchFailures failures = new BatchFailures();
        StoryRunner.State beforeStories = this.storyRunner.runBeforeOrAfterStories(configuration, candidateSteps, StepCollector.Stage.BEFORE);
        if (this.storyRunner.failed(beforeStories)) {
            failures.put(beforeStories.toString(), this.storyRunner.failure(beforeStories));
        }
        ArrayList<Future<ThrowableStory>> futures = new ArrayList<Future<ThrowableStory>>();
        for (String storyPath : storyPaths) {
            this.enqueueStory(failures, filter, futures, storyPath, this.storyRunner.storyOfPath(configuration, storyPath), beforeStories);
        }
        this.waitUntilAllDoneOrFailed(futures, embedderControls, failures);
        StoryRunner.State afterStories = this.storyRunner.runBeforeOrAfterStories(configuration, candidateSteps, StepCollector.Stage.AFTER);
        if (this.storyRunner.failed(afterStories)) {
            failures.put(afterStories.toString(), this.storyRunner.failure(afterStories));
        }
        if (failures.size() > 0) {
            if (embedderControls.ignoreFailureInStories()) {
                this.embedderMonitor.batchFailed(failures);
            } else {
                throw new RunningStoriesFailed(failures);
            }
        }
        if (embedderControls.generateViewAfterStories()) {
            this.generateReportsView();
        }
    }

    public Future<ThrowableStory> enqueueStory(BatchFailures batchFailures, MetaFilter filter, List<Future<ThrowableStory>> futures, String storyPath, Story story) {
        return this.enqueueStory(batchFailures, filter, futures, storyPath, story, null);
    }

    private Future<ThrowableStory> enqueueStory(BatchFailures batchFailures, MetaFilter filter, List<Future<ThrowableStory>> futures, String storyPath, Story story, StoryRunner.State beforeStories) {
        EnqueuedStory enqueuedStory = this.enqueuedStory(this.embedderControls, this.configuration, this.stepsFactory, batchFailures, filter, storyPath, story, beforeStories);
        return this.submit(futures, enqueuedStory);
    }

    private synchronized Future<ThrowableStory> submit(List<Future<ThrowableStory>> futures, EnqueuedStory enqueuedStory) {
        if (this.executorService == null) {
            this.useExecutorService(this.createExecutorService());
        }
        Future<ThrowableStory> submit = this.executorService.submit(enqueuedStory);
        futures.add(submit);
        return submit;
    }

    protected EnqueuedStory enqueuedStory(EmbedderControls embedderControls, Configuration configuration, InjectableStepsFactory stepsFactory, BatchFailures batchFailures, MetaFilter filter, String storyPath, Story story, StoryRunner.State beforeStories) {
        return new EnqueuedStory(storyPath, configuration, stepsFactory, story, filter, embedderControls, batchFailures, this.embedderMonitor, this.storyRunner, beforeStories);
    }

    protected ExecutorService createExecutorService() {
        int threads = this.embedderControls.threads();
        this.embedderMonitor.usingThreads(threads);
        return Executors.newFixedThreadPool(threads);
    }

    private void waitUntilAllDoneOrFailed(List<Future<ThrowableStory>> futures, EmbedderControls embedderControls, BatchFailures failures) {
        long start = System.currentTimeMillis();
        boolean allDone = false;
        block6: while (!allDone) {
            allDone = true;
            for (Future<ThrowableStory> future : futures) {
                if (!future.isDone()) {
                    long timeoutInSecs;
                    allDone = false;
                    long durationInSecs = this.storyDurationInSecs(start);
                    if (durationInSecs > (timeoutInSecs = embedderControls.storyTimeoutInSecs())) {
                        Story story = null;
                        try {
                            story = future.get().getStory();
                        }
                        catch (Throwable e) {
                            failures.put(future.toString(), e);
                            if (!embedderControls.ignoreFailureInStories()) continue block6;
                        }
                        this.embedderMonitor.storyTimeout(story, durationInSecs, timeoutInSecs);
                        future.cancel(true);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
                try {
                    ThrowableStory throwableStory = future.get();
                    if (throwableStory.throwable == null) continue;
                    failures.put(future.toString(), throwableStory.throwable);
                    if (embedderControls.ignoreFailureInStories()) continue;
                }
                catch (Throwable e) {
                    failures.put(future.toString(), e);
                    if (embedderControls.ignoreFailureInStories()) continue;
                }
                continue block6;
            }
        }
        for (Future<ThrowableStory> future : futures) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }

    private long storyDurationInSecs(long start) {
        return (System.currentTimeMillis() - start) / 1000L;
    }

    private void configureReporterBuilder(Configuration configuration) {
        StoryReporterBuilder reporterBuilder = configuration.storyReporterBuilder();
        reporterBuilder.withMultiThreading(this.embedderControls.threads() > 1);
        configuration.useStoryReporterBuilder(reporterBuilder);
    }

    public void generateReportsView() {
        StoryReporterBuilder builder = this.configuration().storyReporterBuilder();
        File outputDirectory = builder.outputDirectory();
        List<String> formatNames = builder.formatNames(true);
        this.generateReportsView(outputDirectory, formatNames, builder.viewResources());
    }

    public void generateReportsView(File outputDirectory, List<String> formats, Properties viewResources) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.reportsViewNotGenerated();
            return;
        }
        ViewGenerator viewGenerator = this.configuration().viewGenerator();
        try {
            this.embedderMonitor.generatingReportsView(outputDirectory, formats, viewResources);
            viewGenerator.generateReportsView(outputDirectory, formats, viewResources);
        }
        catch (RuntimeException e) {
            this.embedderMonitor.reportsViewGenerationFailed(outputDirectory, formats, viewResources, e);
            throw new ViewGenerationFailed(outputDirectory, formats, viewResources, e);
        }
        ReportsCount count = viewGenerator.getReportsCount();
        this.embedderMonitor.reportsViewGenerated(count);
        this.handleFailure(embedderControls, count);
    }

    private void handleFailure(EmbedderControls embedderControls, ReportsCount count) {
        if (!embedderControls.ignoreFailureInView()) {
            boolean failed = count.failed();
            if (this.configuration().pendingStepStrategy() instanceof FailingUponPendingStep) {
                boolean bl = failed = failed || count.pending();
            }
            if (failed) {
                throw new RunningStoriesFailed(count);
            }
        }
    }

    public void generateCrossReference() {
        StoryReporterBuilder builder = this.configuration().storyReporterBuilder();
        if (builder.hasCrossReference()) {
            builder.crossReference().outputToFiles(builder);
        }
    }

    public void reportStepdocs() {
        this.reportStepdocs(this.configuration(), this.candidateSteps());
    }

    public void reportStepdocsAsEmbeddables(List<String> classNames) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.embeddablesSkipped(classNames);
            return;
        }
        for (Embeddable embeddable : this.embeddables(classNames, this.classLoader())) {
            if (embeddable instanceof ConfigurableEmbedder) {
                ConfigurableEmbedder configurableEmbedder = (ConfigurableEmbedder)embeddable;
                List<CandidateSteps> steps = configurableEmbedder.candidateSteps();
                if (steps.isEmpty()) {
                    steps = configurableEmbedder.stepsFactory().createCandidateSteps();
                }
                this.reportStepdocs(configurableEmbedder.configuration(), steps);
                continue;
            }
            this.embedderMonitor.embeddableNotConfigurable(embeddable.getClass().getName());
        }
    }

    public void reportStepdocs(Configuration configuration, List<CandidateSteps> candidateSteps) {
        StepFinder finder = configuration.stepFinder();
        StepdocReporter reporter = configuration.stepdocReporter();
        List<Object> stepsInstances = finder.stepsInstances(candidateSteps);
        reporter.stepdocs(finder.stepdocs(candidateSteps), stepsInstances);
    }

    public void reportMatchingStepdocs(String stepAsString) {
        Configuration configuration = this.configuration();
        List<CandidateSteps> candidateSteps = this.candidateSteps();
        StepFinder finder = configuration.stepFinder();
        StepdocReporter reporter = configuration.stepdocReporter();
        List<Stepdoc> matching = finder.findMatching(stepAsString, candidateSteps);
        List<Object> stepsInstances = finder.stepsInstances(candidateSteps);
        reporter.stepdocsMatching(stepAsString, matching, stepsInstances);
    }

    public void processSystemProperties() {
        Properties properties = this.systemProperties();
        this.embedderMonitor.processingSystemProperties(properties);
        if (!properties.isEmpty()) {
            for (Object key : properties.keySet()) {
                String name = (String)key;
                String value = properties.getProperty(name);
                System.setProperty(name, value);
                this.embedderMonitor.systemPropertySet(name, value);
            }
        }
    }

    public EmbedderClassLoader classLoader() {
        return this.classLoader;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<CandidateSteps> candidateSteps() {
        return this.candidateSteps;
    }

    public InjectableStepsFactory stepsFactory() {
        if (this.stepsFactory == null) {
            this.stepsFactory = new ProvidedStepsFactory(this.candidateSteps);
        }
        return this.stepsFactory;
    }

    public EmbedderControls embedderControls() {
        return this.embedderControls;
    }

    public EmbedderMonitor embedderMonitor() {
        return this.embedderMonitor;
    }

    public List<String> metaFilters() {
        return this.metaFilters;
    }

    public StoryRunner storyRunner() {
        return this.storyRunner;
    }

    public Properties systemProperties() {
        return this.systemProperties;
    }

    public void useClassLoader(EmbedderClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void useCandidateSteps(List<CandidateSteps> candidateSteps) {
        this.candidateSteps = candidateSteps;
    }

    public void useStepsFactory(InjectableStepsFactory stepsFactory) {
        this.stepsFactory = stepsFactory;
    }

    public void useEmbedderControls(EmbedderControls embedderControls) {
        this.embedderControls = embedderControls;
    }

    public void useEmbedderMonitor(EmbedderMonitor embedderMonitor) {
        this.embedderMonitor = embedderMonitor;
    }

    public void useExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.embedderMonitor.usingExecutorService(executorService);
    }

    public void useMetaFilters(List<String> metaFilters) {
        this.metaFilters = metaFilters;
    }

    public void useStoryRunner(StoryRunner storyRunner) {
        this.storyRunner = storyRunner;
    }

    public void useSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class ThrowableStory {
        private Throwable throwable;
        private Story story;

        public ThrowableStory(Throwable throwable, Story story) {
            this.throwable = throwable;
            this.story = story;
        }

        public Story getStory() {
            return this.story;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnqueuedStory
    implements Callable<ThrowableStory> {
        private final String storyPath;
        private final Configuration configuration;
        private final InjectableStepsFactory stepsFactory;
        private final Story story;
        private final MetaFilter filter;
        private final EmbedderControls embedderControls;
        private final BatchFailures batchFailures;
        private final EmbedderMonitor embedderMonitor;
        private final StoryRunner storyRunner;
        private final StoryRunner.State beforeStories;

        public EnqueuedStory(String storyPath, Configuration configuration, List<CandidateSteps> candidateSteps, Story story, MetaFilter filter, EmbedderControls embedderControls, BatchFailures batchFailures, EmbedderMonitor embedderMonitor, StoryRunner storyRunner, StoryRunner.State beforeStories) {
            this(storyPath, configuration, new ProvidedStepsFactory(candidateSteps), story, filter, embedderControls, batchFailures, embedderMonitor, storyRunner, beforeStories);
        }

        public EnqueuedStory(String storyPath, Configuration configuration, InjectableStepsFactory stepsFactory, Story story, MetaFilter filter, EmbedderControls embedderControls, BatchFailures batchFailures, EmbedderMonitor embedderMonitor, StoryRunner storyRunner, StoryRunner.State beforeStories) {
            this.storyPath = storyPath;
            this.configuration = configuration;
            this.stepsFactory = stepsFactory;
            this.story = story;
            this.filter = filter;
            this.embedderControls = embedderControls;
            this.batchFailures = batchFailures;
            this.embedderMonitor = embedderMonitor;
            this.storyRunner = storyRunner;
            this.beforeStories = beforeStories;
        }

        @Override
        public ThrowableStory call() throws Exception {
            try {
                this.embedderMonitor.runningStory(this.storyPath);
                this.storyRunner.run(this.configuration, this.stepsFactory, this.story, this.filter, this.beforeStories);
            }
            catch (Throwable e) {
                if (this.embedderControls.batch()) {
                    this.batchFailures.put(this.storyPath, e);
                }
                if (this.embedderControls.ignoreFailureInStories()) {
                    this.embedderMonitor.storyFailed(this.storyPath, e);
                }
                return new ThrowableStory(new RunningStoriesFailed(this.storyPath, e), this.story);
            }
            return new ThrowableStory(null, this.story);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewGenerationFailed
    extends RuntimeException {
        public ViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewResources, RuntimeException cause) {
            super("View generation failed to " + outputDirectory + " for formats " + formats + " and resources " + viewResources, cause);
        }

        public ViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewResources, RuntimeException cause) {
            super("View generation failed to " + outputDirectory + " for story maps " + storyMaps + " for resources " + viewResources, cause);
        }
    }

    public static class RunningStoriesFailed
    extends RuntimeException {
        public RunningStoriesFailed(ReportsCount count) {
            super("Failures in running stories: " + count);
        }

        public RunningStoriesFailed(BatchFailures failures) {
            super("Failures in running stories in batch: " + failures);
        }

        public RunningStoriesFailed(String name, Throwable cause) {
            super("Failures in running stories " + name, cause);
        }

        public RunningStoriesFailed() {
            super("Failures in running before or after stories steps");
        }
    }

    public static class RunningEmbeddablesFailed
    extends RuntimeException {
        public RunningEmbeddablesFailed(String name, Throwable cause) {
            super("Failures in running embeddable " + name, cause);
        }

        public RunningEmbeddablesFailed(BatchFailures batchFailures) {
            super("Failures in running embeddables in batch: " + batchFailures);
        }
    }

    public static class AnnotatedEmbedderRunFailed
    extends RuntimeException {
        public AnnotatedEmbedderRunFailed(AnnotatedEmbedderRunner runner, Throwable cause) {
            super("Annotated embedder run failed with runner " + ((Object)((Object)runner)).toString(), cause);
        }
    }
}

