/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.PrintStreamEmbedderMonitor;
import org.jbehave.core.model.Meta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaFilter {
    public static final MetaFilter EMPTY = new MetaFilter();
    private final Properties include = new Properties();
    private final Properties exclude = new Properties();
    private final String filterAsString;
    private final EmbedderMonitor monitor;

    public MetaFilter() {
        this("");
    }

    public MetaFilter(String filterAsString) {
        this(filterAsString, new PrintStreamEmbedderMonitor());
    }

    public MetaFilter(String filterAsString, EmbedderMonitor monitor) {
        this.filterAsString = filterAsString == null ? "" : filterAsString;
        this.monitor = monitor;
        this.parse(this.include, "+");
        this.parse(this.exclude, "-");
    }

    private void parse(Properties properties, String prefix) {
        properties.clear();
        for (String found : this.found(prefix)) {
            Meta.Property property = new Meta.Property(StringUtils.removeStartIgnoreCase((String)found, (String)prefix));
            properties.setProperty(property.getName(), property.getValue());
        }
    }

    private Set<String> found(String prefix) {
        Matcher matcher = this.findAllPrefixed(prefix).matcher(this.filterAsString);
        HashSet<String> found = new HashSet<String>();
        while (matcher.find()) {
            found.add(matcher.group().trim());
        }
        return found;
    }

    private Pattern findAllPrefixed(String prefix) {
        return Pattern.compile("(\\" + prefix + "(\\w|\\s|\\*)*)", 32);
    }

    public boolean allow(Meta meta) {
        boolean allowed = !this.include.isEmpty() && this.exclude.isEmpty() ? this.match(this.include, meta) : (this.include.isEmpty() && !this.exclude.isEmpty() ? !this.match(this.exclude, meta) : (!this.include.isEmpty() && !this.exclude.isEmpty() ? this.match(this.merge(this.include, this.exclude), meta) && !this.match(this.exclude, meta) : true));
        if (!allowed) {
            this.monitor.metaNotAllowed(meta, this);
        }
        return allowed;
    }

    private Properties merge(Properties include, Properties exclude) {
        HashSet<Object> in = new HashSet<Object>(include.keySet());
        in.addAll(exclude.keySet());
        Properties merged = new Properties();
        for (Object e : in) {
            if (include.containsKey(e)) {
                merged.put(e, include.get(e));
                continue;
            }
            if (!exclude.containsKey(e)) continue;
            merged.put(e, exclude.get(e));
        }
        return merged;
    }

    private boolean match(Properties properties, Meta meta) {
        boolean matches = false;
        block0: for (Object key : properties.keySet()) {
            String property = (String)properties.get(key);
            for (String metaName : meta.getPropertyNames()) {
                if (key.equals(metaName)) {
                    String value = meta.getProperty(metaName);
                    matches = StringUtils.isBlank((String)value) ? true : (property.contains("*") ? value.matches(property.replace("*", ".*")) : properties.get(key).equals(value));
                }
                if (!matches) continue;
                continue block0;
            }
        }
        return matches;
    }

    public Properties include() {
        return this.include;
    }

    public Properties exclude() {
        return this.exclude;
    }

    public String asString() {
        return this.filterAsString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

