/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PendingStepFound;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.ConcurrentStoryReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.PendingStepMethodGenerator;
import org.jbehave.core.steps.ProvidedStepsFactory;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryRunner {
    private ThreadLocal<FailureStrategy> currentStrategy = new ThreadLocal();
    private ThreadLocal<FailureStrategy> failureStrategy = new ThreadLocal();
    private ThreadLocal<PendingStepStrategy> pendingStepStrategy = new ThreadLocal();
    private ThreadLocal<UUIDExceptionWrapper> storyFailure = new ThreadLocal();
    private ThreadLocal<StoryReporter> reporter = new ThreadLocal();
    private ThreadLocal<String> reporterStoryPath = new ThreadLocal();
    private ThreadLocal<State> storiesState = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State runBeforeOrAfterStories(Configuration configuration, List<CandidateSteps> candidateSteps, StepCollector.Stage stage) {
        String storyPath = StringUtils.capitalizeFirstLetter((String)stage.name().toLowerCase()) + "Stories";
        this.reporter.set(configuration.storyReporter(storyPath));
        this.reporter.get().beforeStory(new Story(storyPath), false);
        RunContext context = new RunContext(configuration, candidateSteps, storyPath, MetaFilter.EMPTY);
        if (stage == StepCollector.Stage.BEFORE) {
            this.resetStoryFailure(context);
        }
        if (stage == StepCollector.Stage.AFTER && this.storiesState.get() != null) {
            context.stateIs(this.storiesState.get());
        }
        this.runStepsWhileKeepingState(context, configuration.stepCollector().collectBeforeOrAfterStoriesSteps(context.candidateSteps(), stage));
        this.reporter.get().afterStory(false);
        this.storiesState.set(context.state());
        if (stage == StepCollector.Stage.AFTER) {
            try {
                this.handleStoryFailureByStrategy();
            }
            catch (Throwable e) {
                SomethingHappened somethingHappened = new SomethingHappened(this.storyFailure.get());
                return somethingHappened;
            }
            finally {
                if (this.reporter.get() instanceof ConcurrentStoryReporter) {
                    ((ConcurrentStoryReporter)this.reporter.get()).invokeDelayed();
                }
            }
        }
        return context.state();
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story) throws Throwable {
        this.run(configuration, candidateSteps, story, MetaFilter.EMPTY);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story, MetaFilter filter) throws Throwable {
        this.run(configuration, candidateSteps, story, filter, null);
    }

    public void run(Configuration configuration, List<CandidateSteps> candidateSteps, Story story, MetaFilter filter, State beforeStories) throws Throwable {
        this.run(configuration, new ProvidedStepsFactory(candidateSteps), story, filter, beforeStories);
    }

    public void run(Configuration configuration, InjectableStepsFactory stepsFactory, Story story, MetaFilter filter, State beforeStories) throws Throwable {
        RunContext context = new RunContext(configuration, stepsFactory, story.getPath(), filter);
        if (beforeStories != null) {
            context.stateIs(beforeStories);
        }
        HashMap<String, String> storyParameters = new HashMap<String, String>();
        this.run(context, story, storyParameters);
    }

    public Story storyOfPath(Configuration configuration, String storyPath) {
        String storyAsText = configuration.storyLoader().loadStoryAsText(storyPath);
        return configuration.storyParser().parseStory(storyAsText, storyPath);
    }

    private void run(RunContext context, Story story, Map<String, String> storyParameters) throws Throwable {
        try {
            this.runIt(context, story, storyParameters);
        }
        catch (InterruptedException interruptedException) {
            this.reporter.get().cancelled();
            throw interruptedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIt(RunContext context, Story story, Map<String, String> storyParameters) throws Throwable {
        if (!context.givenStory) {
            this.reporter.set(this.reporterFor(context, story));
        }
        this.pendingStepStrategy.set(context.configuration().pendingStepStrategy());
        this.failureStrategy.set(context.configuration().failureStrategy());
        try {
            this.resetStoryFailure(context);
            if (context.dryRun()) {
                this.reporter.get().dryRun();
            }
            if (context.configuration().storyControls().resetStateBeforeStory()) {
                context.resetState();
            }
            this.reporter.get().beforeStory(story, context.givenStory());
            boolean storyAllowed = true;
            if (context.metaNotAllowed(story.getMeta())) {
                this.reporter.get().storyNotAllowed(story, context.metaFilterAsString());
                storyAllowed = false;
            }
            if (storyAllowed) {
                this.reporter.get().narrative(story.getNarrative());
                this.runBeforeOrAfterStorySteps(context, story, StepCollector.Stage.BEFORE);
                boolean runBeforeAndAfterScenarioSteps = this.shouldRunBeforeOrAfterScenarioSteps(context);
                for (Scenario scenario : story.getScenarios()) {
                    boolean scenarioAllowed = true;
                    if (this.failureOccurred(context) && context.configuration().storyControls().skipScenariosAfterFailure()) continue;
                    this.reporter.get().beforeScenario(scenario.getTitle());
                    this.reporter.get().scenarioMeta(scenario.getMeta());
                    Meta storyAndScenarioMeta = scenario.getMeta().inheritFrom(story.getMeta());
                    if (context.metaNotAllowed(storyAndScenarioMeta)) {
                        this.reporter.get().scenarioNotAllowed(scenario, context.metaFilterAsString());
                        scenarioAllowed = false;
                    }
                    if (scenarioAllowed) {
                        if (context.configuration().storyControls().resetStateBeforeScenario()) {
                            context.resetState();
                        }
                        if (runBeforeAndAfterScenarioSteps) {
                            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.NORMAL);
                        }
                        this.runGivenStories(scenario, context);
                        if (this.isParameterisedByExamples(scenario)) {
                            this.runParametrisedScenariosByExamples(context, scenario, storyAndScenarioMeta);
                        } else {
                            this.addMetaParameters(storyParameters, storyAndScenarioMeta);
                            this.runScenarioSteps(context, scenario, storyParameters);
                        }
                        if (runBeforeAndAfterScenarioSteps) {
                            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.NORMAL);
                        }
                    }
                    this.reporter.get().afterScenario();
                }
                this.runBeforeOrAfterStorySteps(context, story, StepCollector.Stage.AFTER);
            }
            this.reporter.get().afterStory(context.givenStory());
            if (!context.givenStory()) {
                this.handleStoryFailureByStrategy();
            }
        }
        finally {
            if (!context.givenStory() && this.reporter.get() instanceof ConcurrentStoryReporter) {
                ((ConcurrentStoryReporter)this.reporter.get()).invokeDelayed();
            }
        }
    }

    private void addMetaParameters(Map<String, String> storyParameters, Meta meta) {
        for (String name : meta.getPropertyNames()) {
            storyParameters.put(name, meta.getProperty(name));
        }
    }

    private boolean shouldRunBeforeOrAfterScenarioSteps(RunContext context) {
        Configuration configuration = context.configuration();
        if (!configuration.storyControls().skipBeforeAndAfterScenarioStepsIfGivenStory()) {
            return true;
        }
        return !context.givenStory();
    }

    private boolean failureOccurred(RunContext context) {
        return context.failureOccurred();
    }

    private StoryReporter reporterFor(RunContext context, Story story) {
        Configuration configuration = context.configuration();
        if (context.givenStory()) {
            return configuration.storyReporter(this.reporterStoryPath.get());
        }
        this.reporterStoryPath.set(story.getPath());
        return configuration.storyReporter(this.reporterStoryPath.get());
    }

    private void handleStoryFailureByStrategy() throws Throwable {
        Throwable throwable = this.storyFailure.get();
        if (throwable != null) {
            this.currentStrategy.get().handleFailure(throwable);
        }
    }

    private void resetStoryFailure(RunContext context) {
        if (context.givenStory()) {
            return;
        }
        this.currentStrategy.set(context.configuration().failureStrategy());
        this.storyFailure.set(null);
    }

    private void runGivenStories(Scenario scenario, RunContext context) throws Throwable {
        GivenStories givenStories = scenario.getGivenStories();
        if (givenStories.getPaths().size() > 0) {
            this.reporter.get().givenStories(givenStories);
            for (GivenStory givenStory : givenStories.getStories()) {
                RunContext childContext = context.childContextFor(givenStory);
                Story story = this.storyOfPath(context.configuration(), childContext.path());
                this.run(childContext, story, givenStory.getParameters());
            }
        }
    }

    private boolean isParameterisedByExamples(Scenario scenario) {
        return scenario.getExamplesTable().getRowCount() > 0 && !scenario.getGivenStories().requireParameters();
    }

    private void runParametrisedScenariosByExamples(RunContext context, Scenario scenario, Meta storyAndScenarioMeta) {
        ExamplesTable table = scenario.getExamplesTable();
        this.reporter.get().beforeExamples(scenario.getSteps(), table);
        for (Map<String, String> scenarioParameters : table.getRows()) {
            this.reporter.get().example(scenarioParameters);
            if (context.configuration().storyControls().resetStateBeforeScenario()) {
                context.resetState();
            }
            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.BEFORE, ScenarioType.EXAMPLE);
            this.runScenarioSteps(context, scenario, scenarioParameters);
            this.runBeforeOrAfterScenarioSteps(context, scenario, storyAndScenarioMeta, StepCollector.Stage.AFTER, ScenarioType.EXAMPLE);
        }
        this.reporter.get().afterExamples();
    }

    private void runBeforeOrAfterStorySteps(RunContext context, Story story, StepCollector.Stage stage) {
        this.runStepsWhileKeepingState(context, context.collectBeforeOrAfterStorySteps(story, stage));
    }

    private void runBeforeOrAfterScenarioSteps(RunContext context, Scenario scenario, Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
        this.runStepsWhileKeepingState(context, context.collectBeforeOrAfterScenarioSteps(storyAndScenarioMeta, stage, type));
    }

    private void runScenarioSteps(RunContext context, Scenario scenario, Map<String, String> scenarioParameters) {
        boolean restart = true;
        while (restart) {
            restart = false;
            List<Step> steps = context.collectScenarioSteps(scenario, scenarioParameters);
            try {
                this.runStepsWhileKeepingState(context, steps);
            }
            catch (RestartingScenarioFailure e) {
                restart = true;
                continue;
            }
            this.generatePendingStepMethods(context, steps);
        }
    }

    private void generatePendingStepMethods(RunContext context, List<Step> steps) {
        ArrayList<StepCreator.PendingStep> pendingSteps = new ArrayList<StepCreator.PendingStep>();
        for (Step step : steps) {
            if (!(step instanceof StepCreator.PendingStep)) continue;
            pendingSteps.add((StepCreator.PendingStep)step);
        }
        if (!pendingSteps.isEmpty()) {
            PendingStepMethodGenerator generator = new PendingStepMethodGenerator(context.configuration().keywords());
            ArrayList<String> methods = new ArrayList<String>();
            for (StepCreator.PendingStep pendingStep : pendingSteps) {
                if (pendingStep.annotated()) continue;
                methods.add(generator.generateMethod(pendingStep));
            }
            this.reporter.get().pendingMethods(methods);
        }
    }

    private void runStepsWhileKeepingState(RunContext context, List<Step> steps) {
        if (steps == null || steps.size() == 0) {
            return;
        }
        State state = context.state();
        for (Step step : steps) {
            try {
                state = state.run(step);
            }
            catch (RestartingScenarioFailure e) {
                this.reporter.get().restarted(step.toString(), e);
                throw e;
            }
        }
        context.stateIs(state);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean failed(State state) {
        return !state.getClass().equals(FineSoFar.class);
    }

    public Throwable failure(State state) {
        if (this.failed(state)) {
            return ((SomethingHappened)state).scenarioFailure.getCause();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunContext {
        private final Configuration configuration;
        private final List<CandidateSteps> candidateSteps;
        private final String path;
        private final MetaFilter filter;
        private final boolean givenStory;
        private State state;

        public RunContext(Configuration configuration, InjectableStepsFactory stepsFactory, String path, MetaFilter filter) {
            this(configuration, stepsFactory.createCandidateSteps(), path, filter);
        }

        public RunContext(Configuration configuration, List<CandidateSteps> steps, String path, MetaFilter filter) {
            this(configuration, steps, path, filter, false);
        }

        private RunContext(Configuration configuration, List<CandidateSteps> steps, String path, MetaFilter filter, boolean givenStory) {
            this.configuration = configuration;
            this.candidateSteps = steps;
            this.path = path;
            this.filter = filter;
            this.givenStory = givenStory;
            this.resetState();
        }

        public boolean dryRun() {
            return this.configuration.storyControls().dryRun();
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public List<CandidateSteps> candidateSteps() {
            return this.candidateSteps;
        }

        public boolean givenStory() {
            return this.givenStory;
        }

        public String path() {
            return this.path;
        }

        public boolean metaNotAllowed(Meta meta) {
            return !this.filter.allow(meta);
        }

        public String metaFilterAsString() {
            return this.filter.asString();
        }

        public List<Step> collectBeforeOrAfterStorySteps(Story story, StepCollector.Stage stage) {
            return this.configuration.stepCollector().collectBeforeOrAfterStorySteps(this.candidateSteps, story, stage, this.givenStory);
        }

        public List<Step> collectBeforeOrAfterScenarioSteps(Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
            return this.configuration.stepCollector().collectBeforeOrAfterScenarioSteps(this.candidateSteps, storyAndScenarioMeta, stage, type);
        }

        public List<Step> collectScenarioSteps(Scenario scenario, Map<String, String> parameters) {
            return this.configuration.stepCollector().collectScenarioSteps(this.candidateSteps, scenario, parameters);
        }

        public RunContext childContextFor(GivenStory givenStory) {
            String actualPath = this.configuration.pathCalculator().calculate(this.path, givenStory.getPath());
            return new RunContext(this.configuration, this.candidateSteps, actualPath, this.filter, true);
        }

        public State state() {
            return this.state;
        }

        public void stateIs(State state) {
            this.state = state;
        }

        public boolean failureOccurred() {
            return StoryRunner.this.failed(this.state);
        }

        public void resetState() {
            this.state = new FineSoFar();
        }
    }

    private final class SomethingHappened
    implements State {
        UUIDExceptionWrapper scenarioFailure;

        public SomethingHappened(UUIDExceptionWrapper scenarioFailure) {
            this.scenarioFailure = scenarioFailure;
        }

        public State run(Step step) {
            StepResult result = step.doNotPerform(this.scenarioFailure);
            result.describeTo((StoryReporter)StoryRunner.this.reporter.get());
            return this;
        }
    }

    private final class FineSoFar
    implements State {
        private FineSoFar() {
        }

        public State run(Step step) {
            UUIDExceptionWrapper storyFailureIfItHappened = (UUIDExceptionWrapper)StoryRunner.this.storyFailure.get();
            StepResult result = step.perform(storyFailureIfItHappened);
            result.describeTo((StoryReporter)StoryRunner.this.reporter.get());
            UUIDExceptionWrapper stepFailure = result.getFailure();
            if (stepFailure == null) {
                return this;
            }
            StoryRunner.this.storyFailure.set(this.mostImportantOf(storyFailureIfItHappened, stepFailure));
            StoryRunner.this.currentStrategy.set(this.strategyFor((Throwable)StoryRunner.this.storyFailure.get()));
            return new SomethingHappened(stepFailure);
        }

        private UUIDExceptionWrapper mostImportantOf(UUIDExceptionWrapper failure1, UUIDExceptionWrapper failure2) {
            return failure1 == null ? failure2 : (failure1.getCause() instanceof PendingStepFound ? (failure2 == null ? failure1 : failure2) : failure1);
        }

        private FailureStrategy strategyFor(Throwable failure) {
            if (failure instanceof PendingStepFound) {
                return (FailureStrategy)StoryRunner.this.pendingStepStrategy.get();
            }
            return (FailureStrategy)StoryRunner.this.failureStrategy.get();
        }
    }

    public static interface State {
        public State run(Step var1);
    }
}

