/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.steps.ChainedRow;
import org.jbehave.core.steps.ConvertedParameters;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Parameters;
import org.jbehave.core.steps.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamplesTable {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    public static final ExamplesTable EMPTY = new ExamplesTable("");
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private static final String IGNORABLE_SEPARATOR = "|--";
    private final List<Map<String, String>> data = new ArrayList<Map<String, String>>();
    private final String tableAsString;
    private final String headerSeparator;
    private final String valueSeparator;
    private final String ignorableSeparator;
    private final ParameterConverters parameterConverters;
    private final List<String> headers = new ArrayList<String>();
    private final Properties properties = new Properties();
    private Map<String, String> namedParameters = new HashMap<String, String>();
    private boolean trim = true;
    private final Row defaults;

    public ExamplesTable(String tableAsString) {
        this(tableAsString, "|", "|");
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator) {
        this(tableAsString, headerSeparator, valueSeparator, IGNORABLE_SEPARATOR, new ParameterConverters());
    }

    public ExamplesTable(String tableAsString, String headerSeparator, String valueSeparator, String ignorableSeparator, ParameterConverters parameterConverters) {
        this.tableAsString = tableAsString;
        this.headerSeparator = headerSeparator;
        this.valueSeparator = valueSeparator;
        this.ignorableSeparator = ignorableSeparator;
        this.parameterConverters = parameterConverters;
        this.defaults = new ConvertedParameters(EMPTY_MAP, parameterConverters);
        this.parse();
    }

    private ExamplesTable(ExamplesTable other, Row defaults) {
        this.data.addAll(other.data);
        this.tableAsString = other.tableAsString;
        this.headerSeparator = other.headerSeparator;
        this.valueSeparator = other.valueSeparator;
        this.ignorableSeparator = other.ignorableSeparator;
        this.parameterConverters = other.parameterConverters;
        this.headers.addAll(other.headers);
        this.properties.putAll((Map<?, ?>)other.properties);
        this.defaults = defaults;
    }

    private void parse() {
        this.data.clear();
        this.headers.clear();
        String[] rows = this.splitInRows(this.stripProperties(this.tableAsString.trim()));
        for (int row = 0; row < rows.length; ++row) {
            List<String> columns;
            String rowAsString = rows[row];
            if (rowAsString.startsWith(this.ignorableSeparator)) continue;
            if (row == 0) {
                columns = this.columnsFor(rowAsString, this.headerSeparator);
                this.headers.addAll(columns);
                continue;
            }
            columns = this.columnsFor(rowAsString, this.valueSeparator);
            Map<String, String> map = this.createRowMap();
            for (int column = 0; column < columns.size(); ++column) {
                map.put(this.headers.get(column), columns.get(column));
            }
            this.data.add(map);
        }
    }

    private String stripProperties(String tableAsString) {
        Pattern pattern = Pattern.compile("\\{(.*?)\\}\\s*(.*)", 32);
        Matcher matcher = pattern.matcher(tableAsString);
        if (matcher.matches()) {
            this.parseProperties(matcher.group(1));
            return matcher.group(2);
        }
        return tableAsString;
    }

    private void parseProperties(String propertiesAsString) {
        this.properties.clear();
        try {
            this.properties.load(new ByteArrayInputStream(propertiesAsString.replace(",", "\n").getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.trim = Boolean.parseBoolean(this.properties.getProperty("trim", "true"));
    }

    private String[] splitInRows(String table) {
        return table.split("\n");
    }

    private List<String> columnsFor(String row, String separator) {
        int lastIndex;
        ArrayList<String> columns = new ArrayList<String>();
        for (String column : row.split(this.buildRegex(separator), -1)) {
            columns.add(this.valueOf(column));
        }
        if (StringUtils.isBlank((String)((String)columns.get(0)))) {
            columns.remove(0);
        }
        if ((lastIndex = columns.size() - 1) != -1 && StringUtils.isBlank((String)((String)columns.get(lastIndex)))) {
            columns.remove(lastIndex);
        }
        return columns;
    }

    private String valueOf(String column) {
        return this.trim ? column.trim() : column;
    }

    private String buildRegex(String separator) {
        char[] chars = separator.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : chars) {
            sb.append("\\").append(c);
        }
        return sb.toString();
    }

    protected Map<String, String> createRowMap() {
        return new LinkedHashMap<String, String>();
    }

    public ExamplesTable withDefaults(Parameters defaults) {
        return new ExamplesTable(this, new ChainedRow(defaults, this.defaults));
    }

    public ExamplesTable withNamedParameters(Map<String, String> namedParameters) {
        this.namedParameters = namedParameters;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getRow(int row) {
        return this.data.get(row);
    }

    public Parameters getRowAsParameters(int row) {
        return this.getRowAsParameters(row, false);
    }

    public Parameters getRowAsParameters(int row, boolean replaceNamedParameters) {
        Map<String, String> rowValues = this.getRow(row);
        return this.createParameters(replaceNamedParameters ? this.replaceNamedParameters(rowValues) : rowValues);
    }

    private Map<String, String> replaceNamedParameters(Map<String, String> row) {
        HashMap<String, String> replaced = new HashMap<String, String>();
        for (String key : row.keySet()) {
            String replacedValue = row.get(key);
            for (String namedKey : this.namedParameters.keySet()) {
                String namedValue = this.namedParameters.get(namedKey);
                replacedValue = replacedValue.replaceAll(namedKey, namedValue);
            }
            replaced.put(key, replacedValue);
        }
        return replaced;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public List<Map<String, String>> getRows() {
        return this.data;
    }

    public List<Parameters> getRowsAsParameters() {
        return this.getRowsAsParameters(false);
    }

    public List<Parameters> getRowsAsParameters(boolean replaceNamedParameters) {
        ArrayList<Parameters> rows = new ArrayList<Parameters>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            rows.add(this.getRowAsParameters(row, replaceNamedParameters));
        }
        return rows;
    }

    private Parameters createParameters(Map<String, String> values) {
        return new ConvertedParameters(new ChainedRow(new ConvertedParameters(values, this.parameterConverters), this.defaults), this.parameterConverters);
    }

    public String getHeaderSeparator() {
        return this.headerSeparator;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public String asString() {
        return this.tableAsString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

