/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hamcrest.Matcher;
import org.jbehave.core.failures.UUIDExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutcomesTable {
    private static final List<String> FIELDS = Arrays.asList("Description", "Value", "Matcher", "Verified");
    private static final String NEWLINE = "\n";
    private static final String HEADER_SEPARATOR = "|";
    private static final String VALUE_SEPARATOR = "|";
    private List<Outcome<?>> outcomes = new ArrayList();
    private List<Outcome<?>> failedOutcomes = new ArrayList();
    private UUIDExceptionWrapper failureCause;

    public <T> void addOutcome(String description, T value, Matcher<T> matcher) {
        this.outcomes.add(new Outcome<T>(description, value, matcher));
    }

    public void verify() {
        boolean failed = false;
        this.failedOutcomes.clear();
        for (Outcome<?> outcome : this.outcomes) {
            if (outcome.isVerified()) continue;
            this.failedOutcomes.add(outcome);
            failed = true;
            break;
        }
        if (failed) {
            this.failureCause = new UUIDExceptionWrapper(new OutcomesFailed(this));
            throw this.failureCause;
        }
    }

    public UUIDExceptionWrapper failureCause() {
        return this.failureCause;
    }

    public List<Outcome<?>> getOutcomes() {
        return this.outcomes;
    }

    public List<Outcome<?>> getFailedOutcomes() {
        return this.failedOutcomes;
    }

    public List<String> getOutcomeFields() {
        return FIELDS;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = FIELDS.iterator();
        while (iterator.hasNext()) {
            sb.append("|").append(iterator.next());
            if (iterator.hasNext()) continue;
            sb.append("|").append(NEWLINE);
        }
        for (Outcome<?> outcome : this.outcomes) {
            sb.append("|").append(outcome.getDescription()).append("|").append(outcome.getValue()).append("|").append(outcome.getMatcher()).append("|").append(outcome.isVerified()).append("|").append(NEWLINE);
        }
        return sb.toString();
    }

    public static class OutcomesFailed
    extends UUIDExceptionWrapper {
        private OutcomesTable outcomes;

        public OutcomesFailed(OutcomesTable outcomes) {
            this.outcomes = outcomes;
        }

        public OutcomesTable outcomesTable() {
            return this.outcomes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Outcome<T> {
        private final String description;
        private final T value;
        private final Matcher<T> matcher;
        private final boolean verified;

        public Outcome(String description, T value, Matcher<T> matcher) {
            this.description = description;
            this.value = value;
            this.matcher = matcher;
            this.verified = matcher.matches(value);
        }

        public String getDescription() {
            return this.description;
        }

        public T getValue() {
            return this.value;
        }

        public Matcher<T> getMatcher() {
            return this.matcher;
        }

        public boolean isVerified() {
            return this.verified;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

