/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scenario {
    private final String title;
    private final Meta meta;
    private final List<String> steps;
    private final ExamplesTable examplesTable;
    private final GivenStories givenStories;

    public Scenario() {
        this(Arrays.asList(new String[0]));
    }

    public Scenario(List<String> steps) {
        this("", steps);
    }

    public Scenario(String title, Meta meta) {
        this(title, meta, GivenStories.EMPTY, ExamplesTable.EMPTY, Arrays.asList(new String[0]));
    }

    public Scenario(String title, List<String> steps) {
        this(title, Meta.EMPTY, GivenStories.EMPTY, ExamplesTable.EMPTY, steps);
    }

    public Scenario(String title, Meta meta, GivenStories givenStories, ExamplesTable examplesTable, List<String> steps) {
        this.title = title;
        this.meta = meta;
        this.givenStories = givenStories;
        this.steps = steps;
        this.examplesTable = examplesTable;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public GivenStories getGivenStories() {
        return this.givenStories;
    }

    public List<String> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public String getTitle() {
        return this.title;
    }

    public ExamplesTable getExamplesTable() {
        return this.examplesTable;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

