/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.parsers.RegexStepMatcher;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.StepType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexPrefixCapturingPatternParser
implements StepPatternParser {
    private final String prefix;

    public RegexPrefixCapturingPatternParser() {
        this("$");
    }

    public RegexPrefixCapturingPatternParser(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public StepMatcher parseStep(StepType stepType, String stepPattern) {
        return new RegexStepMatcher(stepType, stepPattern, this.buildPattern(stepPattern), this.extractParameterNames(stepPattern));
    }

    private Pattern buildPattern(String stepPattern) {
        String matchThisButLeaveBrackets = this.escapeRegexPunctuation(stepPattern);
        String patternToMatchAgainst = this.replaceParametersWithCapture(matchThisButLeaveBrackets, this.findParametersToReplace(matchThisButLeaveBrackets));
        String matchThisButIgnoreWhitespace = this.anyWhitespaceWillDo(patternToMatchAgainst);
        return Pattern.compile(matchThisButIgnoreWhitespace, 32);
    }

    private String escapeRegexPunctuation(String matchThis) {
        return matchThis.replaceAll("([\\[\\]\\{\\}\\?\\^\\.\\*\\(\\)\\+\\\\])", "\\\\$1");
    }

    private String anyWhitespaceWillDo(String matchThis) {
        return matchThis.replaceAll("\\s+", "\\\\s+");
    }

    private String[] extractParameterNames(String stepPattern) {
        ArrayList<String> names = new ArrayList<String>();
        for (Parameter parameter : this.findParametersToReplace(stepPattern)) {
            names.add(parameter.name);
        }
        return names.toArray(new String[names.size()]);
    }

    private List<Parameter> findParametersToReplace(String matchThisButLeaveBrackets) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Matcher findingAllPrefixedWords = this.findAllPrefixedWords().matcher(matchThisButLeaveBrackets);
        while (findingAllPrefixedWords.find()) {
            parameters.add(new Parameter(matchThisButLeaveBrackets, findingAllPrefixedWords.start(), findingAllPrefixedWords.end(), findingAllPrefixedWords.group(2)));
        }
        return parameters;
    }

    private Pattern findAllPrefixedWords() {
        return Pattern.compile("(\\" + this.prefix + "\\w*)(\\W|\\Z)", 32);
    }

    private String replaceParametersWithCapture(String escapedMatch, List<Parameter> parameters) {
        String replaced = escapedMatch;
        for (int i = parameters.size(); i > 0; --i) {
            String start = replaced.substring(0, parameters.get(i - 1).start);
            String end = replaced.substring(parameters.get(i - 1).end);
            String whitespaceIfAny = parameters.get(i - 1).whitespaceIfAny;
            replaced = start + "(.*)" + whitespaceIfAny + end;
        }
        return replaced;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private class Parameter {
        private final int start;
        private final int end;
        private final String whitespaceIfAny;
        private final String name;

        public Parameter(String pattern, int start, int end, String whitespaceIfAny) {
            this.start = start;
            this.end = end;
            this.whitespaceIfAny = whitespaceIfAny;
            this.name = pattern.substring(start + RegexPrefixCapturingPatternParser.this.prefix.length(), end).trim();
        }
    }
}

