/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.parsers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.StoryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexStoryParser
implements StoryParser {
    private static final String NONE = "";
    private final Keywords keywords;
    private final ExamplesTableFactory tableFactory;

    public RegexStoryParser() {
        this(new LocalizedKeywords());
    }

    public RegexStoryParser(Keywords keywords) {
        this(keywords, new ExamplesTableFactory());
    }

    public RegexStoryParser(ExamplesTableFactory tableFactory) {
        this(new LocalizedKeywords(), tableFactory);
    }

    public RegexStoryParser(Keywords keywords, ExamplesTableFactory tableFactory) {
        this.keywords = keywords;
        this.tableFactory = tableFactory;
    }

    @Override
    public Story parseStory(String storyAsText) {
        return this.parseStory(storyAsText, null);
    }

    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        Description description = this.parseDescriptionFrom(storyAsText);
        Meta meta = this.parseStoryMetaFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        Story story = new Story(storyPath, description, meta, narrative, scenarios);
        if (storyPath != null) {
            story.namedAs(new File(storyPath).getName());
        }
        return story;
    }

    private Description parseDescriptionFrom(String storyAsText) {
        Matcher findingDescription = this.patternToPullDescriptionIntoGroupOne().matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    private Meta parseStoryMetaFrom(String storyAsText) {
        Matcher findingMeta = this.patternToPullStoryMetaIntoGroupOne().matcher(this.preScenarioText(storyAsText));
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return this.createMeta(meta);
        }
        return Meta.EMPTY;
    }

    private String preScenarioText(String storyAsText) {
        String[] split = storyAsText.split(this.keywords.scenario());
        return split.length > 0 ? split[0] : storyAsText;
    }

    private Meta createMeta(String meta) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String property : meta.split(this.keywords.metaProperty())) {
            String beforeIgnorable;
            if (!StringUtils.isNotBlank((String)property) || !StringUtils.isNotBlank((String)(beforeIgnorable = StringUtils.substringBefore((String)property, (String)this.keywords.ignorable())))) continue;
            properties.add(beforeIgnorable);
        }
        return new Meta(properties);
    }

    private Narrative parseNarrativeFrom(String storyAsText) {
        Matcher findingNarrative = this.patternToPullNarrativeIntoGroupOne().matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    private Narrative createNarrative(String narrative) {
        Pattern findElements = this.patternToPullNarrativeElementsIntoGroups();
        Matcher findingElements = findElements.matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        return Narrative.EMPTY;
    }

    private List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        for (String scenarioAsText : this.splitScenarios(storyAsText)) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    private List<String> splitScenarios(String storyAsText) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = this.keywords.scenario();
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            storyAsText = StringUtils.substringAfter((String)storyAsText, (String)scenarioKeyword);
        }
        for (String scenarioAsText : storyAsText.split(scenarioKeyword)) {
            if (scenarioAsText.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + "\n" + scenarioAsText);
        }
        return scenarios;
    }

    private Scenario parseScenario(String scenarioAsText) {
        String title = this.findScenarioTitle(scenarioAsText);
        Meta meta = this.findScenarioMeta(scenarioAsText);
        ExamplesTable examplesTable = this.findExamplesTable(scenarioAsText);
        GivenStories givenStories = this.findGivenStories(scenarioAsText);
        if (givenStories.requireParameters()) {
            givenStories.useExamplesTable(examplesTable);
        }
        List<String> steps = this.findSteps(scenarioAsText);
        return new Scenario(title, meta, givenStories, examplesTable, steps);
    }

    private String findScenarioTitle(String scenarioAsText) {
        Matcher findingTitle = this.patternToPullScenarioTitleIntoGroupOne().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : NONE;
    }

    private Meta findScenarioMeta(String scenarioAsText) {
        Matcher findingMeta = this.patternToPullScenarioMetaIntoGroupOne().matcher(scenarioAsText);
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return this.createMeta(meta);
        }
        return Meta.EMPTY;
    }

    private ExamplesTable findExamplesTable(String scenarioAsText) {
        Matcher findingTable = this.patternToPullExamplesTableIntoGroupOne().matcher(scenarioAsText);
        String tableInput = findingTable.find() ? findingTable.group(1).trim() : NONE;
        return this.tableFactory.createExamplesTable(tableInput);
    }

    private GivenStories findGivenStories(String scenarioAsText) {
        Matcher findingGivenStories = this.patternToPullGivenStoriesIntoGroupOne().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    private List<String> findSteps(String scenarioAsText) {
        Matcher matcher = this.patternToPullStepsIntoGroupOne().matcher(scenarioAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    private Pattern patternToPullDescriptionIntoGroupOne() {
        String metaOrNarrativeOrScenario = this.concatenateWithOr(this.keywords.meta(), this.keywords.narrative(), this.keywords.scenario());
        return Pattern.compile("(.*?)(" + metaOrNarrativeOrScenario + ").*", 32);
    }

    private Pattern patternToPullStoryMetaIntoGroupOne() {
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(\\Z|" + this.keywords.narrative() + ").*", 32);
    }

    private Pattern patternToPullNarrativeIntoGroupOne() {
        return Pattern.compile(".*" + this.keywords.narrative() + "(.*?)\\s*(" + this.keywords.scenario() + ").*", 32);
    }

    private Pattern patternToPullNarrativeElementsIntoGroups() {
        return Pattern.compile(".*" + this.keywords.inOrderTo() + "(.*)\\s*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)", 32);
    }

    private Pattern patternToPullScenarioTitleIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(this.keywords.scenario() + "((.|\\n)*?)\\s*(" + this.keywords.meta() + "|" + startingWords + ").*", 32);
    }

    private Pattern patternToPullScenarioMetaIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(" + this.keywords.givenStories() + "|" + startingWords + ").*", 32);
    }

    private Pattern patternToPullGivenStoriesIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(".*\\n" + this.keywords.givenStories() + "((.|\\n)*?)\\s*(" + startingWords + ").*", 32);
    }

    private Pattern patternToPullStepsIntoGroupOne() {
        String initialStartingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String followingStartingWords = this.concatenateWithOr("\\n", "\\s", this.keywords.startingWords());
        return Pattern.compile("((" + initialStartingWords + ") (.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords.examplesTable() + ")", 32);
    }

    private Pattern patternToPullExamplesTableIntoGroupOne() {
        return Pattern.compile(".*\\n" + this.keywords.examplesTable() + "\\s*(.*)", 32);
    }

    private String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr((String)null, (String)null, keywords);
    }

    private String concatenateWithOr(String beforeKeyword, String afterKeyword, String[] keywords) {
        StringBuilder builder = new StringBuilder();
        String before = beforeKeyword != null ? beforeKeyword : NONE;
        String after = afterKeyword != null ? afterKeyword : NONE;
        for (String keyword : keywords) {
            builder.append(before).append(keyword).append(after).append("|");
        }
        return StringUtils.chomp((String)builder.toString(), (String)"|");
    }
}

