/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentStoryReporter
implements StoryReporter {
    private static Method storyNotAllowed;
    private static Method beforeStory;
    private static Method narrative;
    private static Method afterStory;
    private static Method scenarioNotAllowed;
    private static Method beforeScenario;
    private static Method scenarioMeta;
    private static Method afterScenario;
    private static Method givenStories;
    private static Method givenStoriesPaths;
    private static Method beforeExamples;
    private static Method example;
    private static Method afterExamples;
    private static Method successful;
    private static Method ignorable;
    private static Method pending;
    private static Method notPerformed;
    private static Method failed;
    private static Method failedOutcomes;
    private static Method dryRun;
    private static Method pendingMethods;
    private static Method restarted;
    private static Method cancelled;
    private List<DelayedMethod> delayedMethods = new ArrayList<DelayedMethod>();
    private final StoryReporter crossReferencing;
    private final StoryReporter delegate;
    private final boolean multiThreading;
    private boolean invoked = false;

    public ConcurrentStoryReporter(StoryReporter crossReferencing, StoryReporter delegate, boolean multiThreading) {
        this.crossReferencing = crossReferencing;
        this.multiThreading = multiThreading;
        this.delegate = delegate;
    }

    @Override
    public void storyNotAllowed(Story story, String filter) {
        this.crossReferencing.storyNotAllowed(story, filter);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(storyNotAllowed, story, filter));
        } else {
            this.delegate.storyNotAllowed(story, filter);
        }
    }

    @Override
    public void beforeStory(Story story, boolean givenStory) {
        this.crossReferencing.beforeStory(story, givenStory);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(beforeStory, story, givenStory));
        } else {
            this.delegate.beforeStory(story, givenStory);
        }
    }

    @Override
    public void narrative(Narrative aNarrative) {
        this.crossReferencing.narrative(aNarrative);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(narrative, aNarrative));
        } else {
            this.delegate.narrative(aNarrative);
        }
    }

    @Override
    public void afterStory(boolean givenStory) {
        this.crossReferencing.afterStory(givenStory);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(afterStory, givenStory));
        } else {
            this.delegate.afterStory(givenStory);
        }
    }

    @Override
    public void scenarioNotAllowed(Scenario scenario, String filter) {
        this.crossReferencing.scenarioNotAllowed(scenario, filter);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(scenarioNotAllowed, scenario, filter));
        } else {
            this.delegate.scenarioNotAllowed(scenario, filter);
        }
    }

    @Override
    public void beforeScenario(String scenarioTitle) {
        this.crossReferencing.beforeScenario(scenarioTitle);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(beforeScenario, scenarioTitle));
        } else {
            this.delegate.beforeScenario(scenarioTitle);
        }
    }

    @Override
    public void scenarioMeta(Meta meta) {
        this.crossReferencing.scenarioMeta(meta);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(scenarioMeta, meta));
        } else {
            this.delegate.scenarioMeta(meta);
        }
    }

    @Override
    public void afterScenario() {
        this.crossReferencing.afterScenario();
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(afterScenario, new Object[0]));
        } else {
            this.delegate.afterScenario();
        }
    }

    @Override
    public void givenStories(GivenStories stories) {
        this.crossReferencing.givenStories(stories);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(givenStories, stories));
        } else {
            this.delegate.givenStories(stories);
        }
    }

    @Override
    public void givenStories(List<String> storyPaths) {
        this.crossReferencing.givenStories(storyPaths);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(givenStoriesPaths, storyPaths));
        } else {
            this.delegate.givenStories(storyPaths);
        }
    }

    @Override
    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.crossReferencing.beforeExamples(steps, table);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(beforeExamples, steps, table));
        } else {
            this.delegate.beforeExamples(steps, table);
        }
    }

    @Override
    public void example(Map<String, String> tableRow) {
        this.crossReferencing.example(tableRow);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(example, tableRow));
        } else {
            this.delegate.example(tableRow);
        }
    }

    @Override
    public void afterExamples() {
        this.crossReferencing.afterExamples();
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(afterExamples, new Object[0]));
        } else {
            this.delegate.afterExamples();
        }
    }

    @Override
    public void successful(String step) {
        this.crossReferencing.successful(step);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(successful, step));
        } else {
            this.delegate.successful(step);
        }
    }

    @Override
    public void ignorable(String step) {
        this.crossReferencing.ignorable(step);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(ignorable, step));
        } else {
            this.delegate.ignorable(step);
        }
    }

    @Override
    public void pending(String step) {
        this.crossReferencing.pending(step);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(pending, step));
        } else {
            this.delegate.pending(step);
        }
    }

    @Override
    public void notPerformed(String step) {
        this.crossReferencing.notPerformed(step);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(notPerformed, step));
        } else {
            this.delegate.notPerformed(step);
        }
    }

    @Override
    public void failed(String step, Throwable cause) {
        this.crossReferencing.failed(step, cause);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(failed, step, cause));
        } else {
            this.delegate.failed(step, cause);
        }
    }

    @Override
    public void failedOutcomes(String step, OutcomesTable table) {
        this.crossReferencing.failedOutcomes(step, table);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(failedOutcomes, step, table));
        } else {
            this.delegate.failedOutcomes(step, table);
        }
    }

    @Override
    public void dryRun() {
        this.crossReferencing.dryRun();
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(dryRun, new Object[0]));
        } else {
            this.delegate.dryRun();
        }
    }

    @Override
    public void pendingMethods(List<String> methods) {
        this.crossReferencing.pendingMethods(methods);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(pendingMethods, methods));
        } else {
            this.delegate.pendingMethods(methods);
        }
    }

    @Override
    public void restarted(String step, Throwable cause) {
        this.crossReferencing.restarted(step, cause);
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(restarted, step, cause));
        } else {
            this.delegate.restarted(step, cause);
        }
    }

    @Override
    public void cancelled() {
        this.crossReferencing.cancelled();
        if (this.multiThreading) {
            this.delayedMethods.add(new DelayedMethod(cancelled, new Object[0]));
        } else {
            this.delegate.cancelled();
        }
    }

    public StoryReporter getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeDelayed() {
        if (!this.multiThreading) {
            return;
        }
        if (this.invoked) {
            throw new RuntimeException("Delayed methods already invoked");
        }
        StoryReporter storyReporter = this.delegate;
        synchronized (storyReporter) {
            for (DelayedMethod delayed : this.delayedMethods) {
                delayed.invoke(this.delegate);
            }
        }
        this.invoked = true;
    }

    static {
        try {
            storyNotAllowed = StoryReporter.class.getMethod("storyNotAllowed", Story.class, String.class);
            beforeStory = StoryReporter.class.getMethod("beforeStory", Story.class, Boolean.TYPE);
            narrative = StoryReporter.class.getMethod("narrative", Narrative.class);
            afterStory = StoryReporter.class.getMethod("afterStory", Boolean.TYPE);
            scenarioNotAllowed = StoryReporter.class.getMethod("scenarioNotAllowed", Scenario.class, String.class);
            beforeScenario = StoryReporter.class.getMethod("beforeScenario", String.class);
            scenarioMeta = StoryReporter.class.getMethod("scenarioMeta", Meta.class);
            afterScenario = StoryReporter.class.getMethod("afterScenario", new Class[0]);
            givenStories = StoryReporter.class.getMethod("givenStories", GivenStories.class);
            givenStoriesPaths = StoryReporter.class.getMethod("givenStories", List.class);
            beforeExamples = StoryReporter.class.getMethod("beforeExamples", List.class, ExamplesTable.class);
            example = StoryReporter.class.getMethod("example", Map.class);
            afterExamples = StoryReporter.class.getMethod("afterExamples", new Class[0]);
            successful = StoryReporter.class.getMethod("successful", String.class);
            ignorable = StoryReporter.class.getMethod("ignorable", String.class);
            pending = StoryReporter.class.getMethod("pending", String.class);
            notPerformed = StoryReporter.class.getMethod("notPerformed", String.class);
            failed = StoryReporter.class.getMethod("failed", String.class, Throwable.class);
            failedOutcomes = StoryReporter.class.getMethod("failedOutcomes", String.class, OutcomesTable.class);
            dryRun = StoryReporter.class.getMethod("dryRun", new Class[0]);
            pendingMethods = StoryReporter.class.getMethod("pendingMethods", List.class);
            restarted = StoryReporter.class.getMethod("restarted", String.class, Throwable.class);
            cancelled = StoryReporter.class.getMethod("cancelled", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class DelayedMethod {
        private Method method;
        private Object[] args;

        public DelayedMethod(Method method, Object ... args) {
            this.method = method;
            this.args = args;
        }

        public void invoke(StoryReporter delegate) {
            try {
                this.method.invoke((Object)delegate, this.args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("" + this.method, e);
            }
        }
    }
}

