/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.io.PrintStream;
import org.jbehave.core.reporters.ANSIConsoleOutput;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.HtmlOutput;
import org.jbehave.core.reporters.HtmlTemplateOuput;
import org.jbehave.core.reporters.IdeOnlyConsoleOutput;
import org.jbehave.core.reporters.PostStoryStatisticsCollector;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.TxtOutput;
import org.jbehave.core.reporters.XmlOutput;

public abstract class Format {
    public static final Format CONSOLE = new Format("CONSOLE"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return new ConsoleOutput(storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format ANSI_CONSOLE = new Format("ANSI_CONSOLE"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return new ANSIConsoleOutput(storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format IDE_CONSOLE = new Format("IDE_CONSOLE"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            return new IdeOnlyConsoleOutput(storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format TXT = new Format("TXT"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("txt"));
            return new TxtOutput(factory.createPrintStream(), storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format HTML = new Format("HTML"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            return new HtmlOutput(factory.createPrintStream(), storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format HTML_TEMPLATE = new Format("HTML"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            return new HtmlTemplateOuput(factory.getOutputFile(), storyReporterBuilder.keywords());
        }
    };
    public static final Format XML = new Format("XML"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("xml"));
            return new XmlOutput(factory.createPrintStream(), storyReporterBuilder.keywords()).doReportFailureTrace(storyReporterBuilder.reportFailureTrace()).doCompressFailureTrace(storyReporterBuilder.compressFailureTrace());
        }
    };
    public static final Format STATS = new Format("STATS"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("stats"));
            return new PostStoryStatisticsCollector(factory.createPrintStream());
        }
    };
    private final String name;

    public Format(String name) {
        this.name = name;
    }

    public abstract StoryReporter createStoryReporter(FilePrintStreamFactory var1, StoryReporterBuilder var2);

    public String name() {
        return this.name;
    }

    public static void println(PrintStream writer, Object what) {
        writer.println(what);
    }

    public String toString() {
        return this.name;
    }
}

