/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.model.Meta;
import org.jbehave.core.steps.SilentStepMonitor;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;

public class BeforeOrAfterStep {
    private final StepCollector.Stage stage;
    private final Method method;
    private final StepCreator stepCreator;
    private final AfterScenario.Outcome outcome;
    private StepMonitor stepMonitor = new SilentStepMonitor();

    public BeforeOrAfterStep(StepCollector.Stage stage, Method method, StepCreator stepCreator) {
        this(stage, method, AfterScenario.Outcome.ANY, stepCreator);
    }

    public BeforeOrAfterStep(StepCollector.Stage stage, Method method, AfterScenario.Outcome outcome, StepCreator stepCreator) {
        this.stage = stage;
        this.method = method;
        this.outcome = outcome;
        this.stepCreator = stepCreator;
    }

    public StepCollector.Stage getStage() {
        return this.stage;
    }

    public Method getMethod() {
        return this.method;
    }

    public Step createStep() {
        return this.createStepWith(Meta.EMPTY);
    }

    public Step createStepWith(Meta meta) {
        return this.stepCreator.createBeforeOrAfterStep(this.method, meta);
    }

    public Step createStepUponOutcome(Meta storyAndScenarioMeta) {
        return this.stepCreator.createAfterStepUponOutcome(this.method, this.outcome, storyAndScenarioMeta);
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
        this.stepCreator.useStepMonitor(stepMonitor);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.stage).append((Object)this.method).append((Object)this.outcome).append((Object)this.stepMonitor).toString();
    }
}

