/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.embedder.Embedder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedderClassLoader
extends URLClassLoader {
    public EmbedderClassLoader(ClassLoader parent) {
        this(Arrays.asList(new String[0]), parent);
    }

    public EmbedderClassLoader(List<String> classpathElements) {
        this(classpathElements, Embedder.class.getClassLoader());
    }

    public EmbedderClassLoader(List<String> classpathElements, ClassLoader parent) {
        super(EmbedderClassLoader.classpathURLs(classpathElements), parent);
    }

    public <T> T newInstance(Class<T> type, String className) {
        try {
            Thread.currentThread().setContextClassLoader(this);
            return (T)this.loadClass(className, true).newInstance();
        }
        catch (Exception e) {
            throw new InstantiationFailed(className, type, this, e);
        }
    }

    public boolean isAbstract(String className) {
        try {
            return Modifier.isAbstract(this.loadClass(className, true).getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    List<String> asShortPaths(URL ... urls) {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : urls) {
            String path = url.getPath();
            if (EmbedderClassLoader.isJar(path)) {
                names.add(EmbedderClassLoader.shortPath(path));
                continue;
            }
            names.add(path);
        }
        return names;
    }

    private static String shortPath(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static boolean isJar(String path) {
        return path.endsWith(".jar");
    }

    private static URL[] classpathURLs(List<String> elements) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (elements != null) {
            for (String element : elements) {
                urls.add(EmbedderClassLoader.toURL(element));
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL toURL(String element) {
        try {
            return new File(element).toURI().toURL();
        }
        catch (Exception e) {
            throw new InvalidClasspathElement(element, e);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("urls", this.asShortPaths(this.getURLs())).append("parent", (Object)this.getParent()).toString();
    }

    public static class InvalidClasspathElement
    extends RuntimeException {
        public InvalidClasspathElement(String element, Throwable cause) {
            super("Invalid classpath element " + element, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstantiationFailed
    extends RuntimeException {
        public InstantiationFailed(String className, Class<?> type, ClassLoader classLoader, Throwable cause) {
            super("Instantiation failed for" + className + " of type " + type + " using class loader " + classLoader, cause);
        }
    }
}

