/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkUnmatchedStepsAsPending
implements StepCollector {
    private final StepFinder stepFinder;
    private final Keywords keywords;

    public MarkUnmatchedStepsAsPending() {
        this(new StepFinder());
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder) {
        this(stepFinder, new LocalizedKeywords());
    }

    public MarkUnmatchedStepsAsPending(Keywords keywords) {
        this(new StepFinder(), keywords);
    }

    public MarkUnmatchedStepsAsPending(StepFinder stepFinder, Keywords keywords) {
        this.stepFinder = stepFinder;
        this.keywords = keywords;
    }

    @Override
    public List<Step> collectBeforeOrAfterStoriesSteps(List<CandidateSteps> candidateSteps, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStories(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterStorySteps(List<CandidateSteps> candidateSteps, Story story, StepCollector.Stage stage, boolean givenStory) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            steps.addAll(this.createSteps(candidates.listBeforeOrAfterStory(givenStory), story.getMeta(), stage));
        }
        return steps;
    }

    @Override
    public List<Step> collectBeforeOrAfterScenarioSteps(List<CandidateSteps> candidateSteps, Meta storyAndScenarioMeta, StepCollector.Stage stage, ScenarioType type) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (CandidateSteps candidates : candidateSteps) {
            List<BeforeOrAfterStep> beforeOrAfterScenarioSteps = candidates.listBeforeOrAfterScenario(type);
            if (stage == StepCollector.Stage.BEFORE) {
                steps.addAll(this.createSteps(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
                continue;
            }
            steps.addAll(0, this.createStepsUponOutcome(beforeOrAfterScenarioSteps, storyAndScenarioMeta, stage));
        }
        return steps;
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, StepCollector.Stage stage) {
        return this.createSteps(beforeOrAfter, null, stage);
    }

    private List<Step> createSteps(List<BeforeOrAfterStep> beforeOrAfter, Meta meta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(meta == null ? step.createStep() : step.createStepWith(meta));
        }
        return steps;
    }

    @Override
    public List<Step> collectScenarioSteps(List<CandidateSteps> candidateSteps, Scenario scenario, Map<String, String> parameters) {
        ArrayList<Step> steps = new ArrayList<Step>();
        this.addMatchedScenarioSteps(scenario, steps, parameters, candidateSteps);
        return steps;
    }

    private List<Step> createStepsUponOutcome(List<BeforeOrAfterStep> beforeOrAfter, Meta storyAndScenarioMeta, StepCollector.Stage stage) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (BeforeOrAfterStep step : beforeOrAfter) {
            if (stage != step.getStage()) continue;
            steps.add(step.createStepUponOutcome(storyAndScenarioMeta));
        }
        return steps;
    }

    private void addMatchedScenarioSteps(Scenario scenario, List<Step> steps, Map<String, String> namedParameters, List<CandidateSteps> candidateSteps) {
        List<StepCandidate> allCandidates = this.stepFinder.collectCandidates(candidateSteps);
        String previousNonAndStep = null;
        for (String stepAsString : scenario.getSteps()) {
            Step step = StepCreator.createPendingStep(stepAsString, previousNonAndStep);
            ArrayList<Step> composedSteps = new ArrayList<Step>();
            List<StepCandidate> prioritisedCandidates = this.stepFinder.prioritise(stepAsString, allCandidates);
            for (StepCandidate candidate : prioritisedCandidates) {
                if (candidate.ignore(stepAsString)) {
                    step = StepCreator.createIgnorableStep(stepAsString);
                    break;
                }
                if (!this.matchesCandidate(stepAsString, previousNonAndStep, candidate)) continue;
                if (candidate.isPending()) {
                    ((StepCreator.PendingStep)step).annotatedOn(candidate.getMethod());
                } else {
                    step = candidate.createMatchedStep(stepAsString, namedParameters);
                    if (candidate.isComposite()) {
                        candidate.addComposedSteps(composedSteps, stepAsString, namedParameters, allCandidates);
                    }
                }
                if (candidate.isAndStep(stepAsString) || candidate.isIgnorableStep(stepAsString)) break;
                previousNonAndStep = stepAsString;
                break;
            }
            if (!this.keywords.isAndStep(stepAsString) && !this.keywords.isIgnorableStep(stepAsString)) {
                previousNonAndStep = stepAsString;
            }
            steps.add(step);
            steps.addAll(composedSteps);
        }
    }

    private boolean matchesCandidate(String step, String previousNonAndStep, StepCandidate candidate) {
        if (previousNonAndStep != null) {
            return candidate.matches(step, previousNonAndStep);
        }
        return candidate.matches(step);
    }
}

